/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.MimeType;
import java.awt.datatransfer.MimeTypeParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import sun.awt.AppContext;
import sun.awt.datatransfer.DataTransferer;

public final class SystemFlavorMap
implements FlavorMap,
FlavorTable {
    private static String JavaMIME = "JAVA_DATAFLAVOR:";
    private static final Object FLAVOR_MAP_KEY = new Object();
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String whiteSpaceChars = " \t\r\n\f";
    private static final String[] UNICODE_TEXT_CLASSES = new String[]{"java.io.Reader", "java.lang.String", "java.nio.CharBuffer", "\"[C\""};
    private static final String[] ENCODED_TEXT_CLASSES = new String[]{"java.io.InputStream", "java.nio.ByteBuffer", "\"[B\""};
    private static final String TEXT_PLAIN_BASE_TYPE = "text/plain";
    private static final String HTML_TEXT_BASE_TYPE = "text/html";
    private final Map<String, LinkedHashSet<DataFlavor>> nativeToFlavor = new HashMap<String, LinkedHashSet<DataFlavor>>();
    private final Map<DataFlavor, LinkedHashSet<String>> flavorToNative = new HashMap<DataFlavor, LinkedHashSet<String>>();
    private Map<String, LinkedHashSet<String>> textTypeToNative = new HashMap<String, LinkedHashSet<String>>();
    private boolean isMapInitialized = false;
    private final SoftCache<DataFlavor, String> nativesForFlavorCache = new SoftCache();
    private final SoftCache<String, DataFlavor> flavorsForNativeCache = new SoftCache();
    private Set<Object> disabledMappingGenerationKeys = new HashSet<Object>();
    private static final String[] htmlDocumntTypes = new String[]{"all", "selection", "fragment"};

    private Map<String, LinkedHashSet<DataFlavor>> getNativeToFlavor() {
        if (!this.isMapInitialized) {
            this.initSystemFlavorMap();
        }
        return this.nativeToFlavor;
    }

    private synchronized Map<DataFlavor, LinkedHashSet<String>> getFlavorToNative() {
        if (!this.isMapInitialized) {
            this.initSystemFlavorMap();
        }
        return this.flavorToNative;
    }

    private synchronized Map<String, LinkedHashSet<String>> getTextTypeToNative() {
        if (!this.isMapInitialized) {
            this.initSystemFlavorMap();
            this.textTypeToNative = Collections.unmodifiableMap(this.textTypeToNative);
        }
        return this.textTypeToNative;
    }

    public static FlavorMap getDefaultFlavorMap() {
        AppContext appContext = AppContext.getAppContext();
        FlavorMap flavorMap = (FlavorMap)appContext.get(FLAVOR_MAP_KEY);
        if (flavorMap == null) {
            flavorMap = new SystemFlavorMap();
            appContext.put(FLAVOR_MAP_KEY, flavorMap);
        }
        return flavorMap;
    }

    private SystemFlavorMap() {
    }

    private void initSystemFlavorMap() {
        if (this.isMapInitialized) {
            return;
        }
        this.isMapInitialized = true;
        BufferedReader bufferedReader = AccessController.doPrivileged(new PrivilegedAction<BufferedReader>(){

            @Override
            public BufferedReader run() {
                String string = System.getProperty("java.home") + File.separator + "lib" + File.separator + "flavormap.properties";
                try {
                    return new BufferedReader(new InputStreamReader(new File(string).toURI().toURL().openStream(), "ISO-8859-1"));
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println("MalformedURLException:" + malformedURLException + " while loading default flavormap.properties file:" + string);
                }
                catch (IOException iOException) {
                    System.err.println("IOException:" + iOException + " while loading default flavormap.properties file:" + string);
                }
                return null;
            }
        });
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Toolkit.getProperty("AWT.DnD.flavorMapFileURL", null);
            }
        });
        if (bufferedReader != null) {
            try {
                this.parseAndStoreReader(bufferedReader);
            }
            catch (IOException iOException) {
                System.err.println("IOException:" + iOException + " while parsing default flavormap.properties file");
            }
        }
        BufferedReader bufferedReader2 = null;
        if (string != null) {
            try {
                bufferedReader2 = new BufferedReader(new InputStreamReader(new URL(string).openStream(), "ISO-8859-1"));
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("MalformedURLException:" + malformedURLException + " while reading AWT.DnD.flavorMapFileURL:" + string);
            }
            catch (IOException iOException) {
                System.err.println("IOException:" + iOException + " while reading AWT.DnD.flavorMapFileURL:" + string);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (bufferedReader2 != null) {
            try {
                this.parseAndStoreReader(bufferedReader2);
            }
            catch (IOException iOException) {
                System.err.println("IOException:" + iOException + " while parsing AWT.DnD.flavorMapFileURL");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseAndStoreReader(BufferedReader var1_1) throws IOException {
        block6: while (true) {
            block20: {
                if ((var2_2 = var1_1.readLine()) == null) {
                    return;
                }
                if (var2_2.length() <= 0 || (var3_3 = var2_2.charAt(0)) == '#' || var3_3 == '!') continue;
                while (this.continueLine(var2_2)) {
                    var4_5 = var1_1.readLine();
                    if (var4_5 == null) {
                        var4_5 = "";
                    }
                    var5_7 = var2_2.substring(0, var2_2.length() - 1);
                    for (var6_8 = 0; var6_8 < var4_5.length() && " \t\r\n\f".indexOf(var4_5.charAt(var6_8)) != -1; ++var6_8) {
                    }
                    var4_5 = var4_5.substring(var6_8, var4_5.length());
                    var2_2 = var5_7 + var4_5;
                }
                var4_4 = var2_2.length();
                for (var5_6 = 0; var5_6 < var4_4 && " \t\r\n\f".indexOf(var2_2.charAt(var5_6)) != -1; ++var5_6) {
                }
                if (var5_6 == var4_4) continue;
                for (var6_8 = var5_6; var6_8 < var4_4; ++var6_8) {
                    var7_9 = var2_2.charAt(var6_8);
                    if (var7_9 == 92) {
                        ++var6_8;
                        continue;
                    }
                    if ("=: \t\r\n\f".indexOf(var7_9) != -1) break;
                }
                for (var7_9 = var6_8; var7_9 < var4_4 && " \t\r\n\f".indexOf(var2_2.charAt(var7_9)) != -1; ++var7_9) {
                }
                if (var7_9 < var4_4 && "=:".indexOf(var2_2.charAt(var7_9)) != -1) {
                    ++var7_9;
                }
                while (var7_9 < var4_4 && " \t\r\n\f".indexOf(var2_2.charAt(var7_9)) != -1) {
                    ++var7_9;
                }
                var8_10 = var2_2.substring(var5_6, var6_8);
                var9_11 = var6_8 < var4_4 ? var2_2.substring(var7_9, var4_4) : "";
                var8_10 = this.loadConvert(var8_10);
                var9_11 = this.loadConvert(var9_11);
                try {
                    var10_12 = new MimeType(var9_11);
                    if (!"text".equals(var10_12.getPrimaryType())) break block20;
                    var11_14 = var10_12.getParameter("charset");
                    if (DataTransferer.doesSubtypeSupportCharset(var10_12.getSubType(), (String)var11_14) && (var12_16 = DataTransferer.getInstance()) != null) {
                        var12_16.registerTextFlavorProperties(var8_10, (String)var11_14, var10_12.getParameter("eoln"), var10_12.getParameter("terminators"));
                    }
                    var10_12.removeParameter("charset");
                    var10_12.removeParameter("class");
                    var10_12.removeParameter("eoln");
                    var10_12.removeParameter("terminators");
                    var9_11 = var10_12.toString();
                }
                catch (MimeTypeParseException var10_13) {
                    var10_13.printStackTrace();
                    continue;
                }
            }
            try {
                var10_12 = new DataFlavor(var9_11);
            }
            catch (Exception var11_15) {
                try {
                    var10_12 = new DataFlavor(var9_11, null);
                }
                catch (Exception var12_17) {
                    var12_17.printStackTrace();
                    continue;
                }
            }
            var11_14 = new LinkedHashSet<E>();
            var11_14.add(var10_12);
            if ("text".equals(var10_12.getPrimaryType())) {
                var11_14.addAll(SystemFlavorMap.convertMimeTypeToDataFlavors(var9_11));
                this.store(var10_12.mimeType.getBaseType(), var8_10, this.getTextTypeToNative());
            }
            var12_16 = var11_14.iterator();
            while (true) {
                if (var12_16.hasNext()) ** break;
                continue block6;
                var13_18 = (DataFlavor)var12_16.next();
                this.store(var13_18, var8_10, this.getFlavorToNative());
                this.store(var8_10, var13_18, this.getNativeToFlavor());
            }
            break;
        }
    }

    private boolean continueLine(String string) {
        int n = 0;
        int n2 = string.length() - 1;
        while (n2 >= 0 && string.charAt(n2--) == '\\') {
            ++n;
        }
        return n % 2 == 1;
    }

    private String loadConvert(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = string.charAt(n2++)) == 92) {
                if ((n3 = string.charAt(n2++)) == 117) {
                    int n4 = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        n3 = string.charAt(n2++);
                        switch (n3) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                n4 = (n4 << 4) + n3 - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                n4 = (n4 << 4) + 10 + n3 - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                n4 = (n4 << 4) + 10 + n3 - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    stringBuilder.append((char)n4);
                    continue;
                }
                if (n3 == 116) {
                    n3 = 9;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 110) {
                    n3 = 10;
                } else if (n3 == 102) {
                    n3 = 12;
                }
                stringBuilder.append((char)n3);
                continue;
            }
            stringBuilder.append((char)n3);
        }
        return stringBuilder.toString();
    }

    private <H, L> void store(H h, L l, Map<H, LinkedHashSet<L>> map) {
        LinkedHashSet<Object> linkedHashSet = map.get(h);
        if (linkedHashSet == null) {
            linkedHashSet = new LinkedHashSet(1);
            map.put(h, linkedHashSet);
        }
        if (!linkedHashSet.contains(l)) {
            linkedHashSet.add(l);
        }
    }

    private LinkedHashSet<DataFlavor> nativeToFlavorLookup(String string) {
        Cloneable cloneable;
        Object object;
        Cloneable cloneable2 = this.getNativeToFlavor().get(string);
        if (string != null && !this.disabledMappingGenerationKeys.contains(string) && (object = DataTransferer.getInstance()) != null && !((HashSet)(cloneable = ((DataTransferer)object).getPlatformMappingsForNative(string))).isEmpty()) {
            if (cloneable2 != null) {
                ((AbstractCollection)((Object)cloneable)).addAll(cloneable2);
            }
            cloneable2 = cloneable;
        }
        if (cloneable2 == null && SystemFlavorMap.isJavaMIMEType(string)) {
            object = SystemFlavorMap.decodeJavaMIMEType(string);
            cloneable = null;
            try {
                cloneable = new DataFlavor((String)object);
            }
            catch (Exception exception) {
                System.err.println("Exception \"" + exception.getClass().getName() + ": " + exception.getMessage() + "\"while constructing DataFlavor for: " + (String)object);
            }
            if (cloneable != null) {
                cloneable2 = new LinkedHashSet(1);
                this.getNativeToFlavor().put(string, (LinkedHashSet<DataFlavor>)cloneable2);
                ((HashSet)cloneable2).add(cloneable);
                this.flavorsForNativeCache.remove(string);
                LinkedHashSet<String> linkedHashSet = this.getFlavorToNative().get(cloneable);
                if (linkedHashSet == null) {
                    linkedHashSet = new LinkedHashSet(1);
                    this.getFlavorToNative().put((DataFlavor)cloneable, linkedHashSet);
                }
                linkedHashSet.add(string);
                this.nativesForFlavorCache.remove((DataFlavor)cloneable);
            }
        }
        return cloneable2 != null ? cloneable2 : new LinkedHashSet(0);
    }

    private LinkedHashSet<String> flavorToNativeLookup(DataFlavor dataFlavor, boolean bl) {
        LinkedHashSet<Object> linkedHashSet;
        Object object;
        LinkedHashSet<String> linkedHashSet2 = this.getFlavorToNative().get(dataFlavor);
        if (dataFlavor != null && !this.disabledMappingGenerationKeys.contains(dataFlavor) && (object = DataTransferer.getInstance()) != null && !(linkedHashSet = ((DataTransferer)object).getPlatformMappingsForFlavor(dataFlavor)).isEmpty()) {
            if (linkedHashSet2 != null) {
                linkedHashSet.addAll(linkedHashSet2);
            }
            linkedHashSet2 = linkedHashSet;
        }
        if (linkedHashSet2 == null) {
            if (bl) {
                object = SystemFlavorMap.encodeDataFlavor(dataFlavor);
                linkedHashSet2 = new LinkedHashSet(1);
                this.getFlavorToNative().put(dataFlavor, linkedHashSet2);
                linkedHashSet2.add((String)object);
                linkedHashSet = this.getNativeToFlavor().get(object);
                if (linkedHashSet == null) {
                    linkedHashSet = new LinkedHashSet(1);
                    this.getNativeToFlavor().put((String)object, linkedHashSet);
                }
                linkedHashSet.add((String)((Object)dataFlavor));
                this.nativesForFlavorCache.remove(dataFlavor);
                this.flavorsForNativeCache.remove((String)object);
            } else {
                linkedHashSet2 = new LinkedHashSet(0);
            }
        }
        return new LinkedHashSet<String>(linkedHashSet2);
    }

    @Override
    public synchronized List<String> getNativesForFlavor(DataFlavor dataFlavor) {
        LinkedHashSet<String> linkedHashSet = this.nativesForFlavorCache.check(dataFlavor);
        if (linkedHashSet != null) {
            return new ArrayList<String>(linkedHashSet);
        }
        if (dataFlavor == null) {
            linkedHashSet = new LinkedHashSet<String>(this.getNativeToFlavor().keySet());
        } else if (this.disabledMappingGenerationKeys.contains(dataFlavor)) {
            linkedHashSet = this.flavorToNativeLookup(dataFlavor, false);
        } else if (DataTransferer.isFlavorCharsetTextType(dataFlavor)) {
            LinkedHashSet<String> linkedHashSet2;
            linkedHashSet = new LinkedHashSet(0);
            if ("text".equals(dataFlavor.getPrimaryType()) && (linkedHashSet2 = this.getTextTypeToNative().get(dataFlavor.mimeType.getBaseType())) != null) {
                linkedHashSet.addAll(linkedHashSet2);
            }
            if ((linkedHashSet2 = this.getTextTypeToNative().get(TEXT_PLAIN_BASE_TYPE)) != null) {
                linkedHashSet.addAll(linkedHashSet2);
            }
            if (linkedHashSet.isEmpty()) {
                linkedHashSet = this.flavorToNativeLookup(dataFlavor, true);
            } else {
                linkedHashSet.addAll(this.flavorToNativeLookup(dataFlavor, false));
            }
        } else if (DataTransferer.isFlavorNoncharsetTextType(dataFlavor)) {
            linkedHashSet = this.getTextTypeToNative().get(dataFlavor.mimeType.getBaseType());
            if (linkedHashSet == null || linkedHashSet.isEmpty()) {
                linkedHashSet = this.flavorToNativeLookup(dataFlavor, true);
            } else {
                linkedHashSet.addAll(this.flavorToNativeLookup(dataFlavor, false));
            }
        } else {
            linkedHashSet = this.flavorToNativeLookup(dataFlavor, true);
        }
        this.nativesForFlavorCache.put(dataFlavor, linkedHashSet);
        return new ArrayList<String>(linkedHashSet);
    }

    @Override
    public synchronized List<DataFlavor> getFlavorsForNative(String string) {
        LinkedHashSet<DataFlavor> linkedHashSet = this.flavorsForNativeCache.check(string);
        if (linkedHashSet != null) {
            return new ArrayList<DataFlavor>(linkedHashSet);
        }
        linkedHashSet = new LinkedHashSet();
        if (string == null) {
            for (String string2 : this.getNativesForFlavor(null)) {
                linkedHashSet.addAll(this.getFlavorsForNative(string2));
            }
        } else {
            LinkedHashSet<DataFlavor> linkedHashSet2 = this.nativeToFlavorLookup(string);
            if (this.disabledMappingGenerationKeys.contains(string)) {
                return new ArrayList<DataFlavor>(linkedHashSet2);
            }
            LinkedHashSet<DataFlavor> linkedHashSet3 = this.nativeToFlavorLookup(string);
            for (DataFlavor dataFlavor : linkedHashSet3) {
                linkedHashSet.add(dataFlavor);
                if (!"text".equals(dataFlavor.getPrimaryType())) continue;
                String string3 = dataFlavor.mimeType.getBaseType();
                linkedHashSet.addAll(SystemFlavorMap.convertMimeTypeToDataFlavors(string3));
            }
        }
        this.flavorsForNativeCache.put(string, linkedHashSet);
        return new ArrayList<DataFlavor>(linkedHashSet);
    }

    private static Set<DataFlavor> convertMimeTypeToDataFlavors(String string) {
        LinkedHashSet<DataFlavor> linkedHashSet = new LinkedHashSet<DataFlavor>();
        String string2 = null;
        try {
            String[] stringArray = new MimeType(string);
            string2 = stringArray.getSubType();
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            // empty catch block
        }
        if (DataTransferer.doesSubtypeSupportCharset(string2, null)) {
            Object object;
            if (TEXT_PLAIN_BASE_TYPE.equals(string)) {
                linkedHashSet.add(DataFlavor.stringFlavor);
            }
            for (String string3 : UNICODE_TEXT_CLASSES) {
                String string4 = string + ";charset=Unicode;class=" + string3;
                LinkedHashSet<String> object4 = SystemFlavorMap.handleHtmlMimeTypes(string, string4);
                for (Object object2 : object4) {
                    object = null;
                    try {
                        object = new DataFlavor((String)object2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    linkedHashSet.add((DataFlavor)object);
                }
            }
            for (String string5 : DataTransferer.standardEncodings()) {
                for (String string3 : ENCODED_TEXT_CLASSES) {
                    Object object2;
                    String string4 = string + ";charset=" + string5 + ";class=" + string3;
                    object2 = SystemFlavorMap.handleHtmlMimeTypes(string, string4);
                    object = ((HashSet)object2).iterator();
                    while (object.hasNext()) {
                        String string6 = (String)object.next();
                        DataFlavor dataFlavor = null;
                        try {
                            dataFlavor = new DataFlavor(string6);
                            if (dataFlavor.equals(DataFlavor.plainTextFlavor)) {
                                dataFlavor = DataFlavor.plainTextFlavor;
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                        linkedHashSet.add(dataFlavor);
                    }
                }
            }
            if (TEXT_PLAIN_BASE_TYPE.equals(string)) {
                linkedHashSet.add(DataFlavor.plainTextFlavor);
            }
        } else {
            for (String string7 : ENCODED_TEXT_CLASSES) {
                DataFlavor dataFlavor = null;
                try {
                    dataFlavor = new DataFlavor(string + ";class=" + string7);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                linkedHashSet.add(dataFlavor);
            }
        }
        return linkedHashSet;
    }

    private static LinkedHashSet<String> handleHtmlMimeTypes(String string, String string2) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (HTML_TEXT_BASE_TYPE.equals(string)) {
            for (String string3 : htmlDocumntTypes) {
                linkedHashSet.add(string2 + ";document=" + string3);
            }
        } else {
            linkedHashSet.add(string2);
        }
        return linkedHashSet;
    }

    @Override
    public synchronized Map<DataFlavor, String> getNativesForFlavors(DataFlavor[] dataFlavorArray) {
        Object object;
        if (dataFlavorArray == null) {
            object = this.getFlavorsForNative(null);
            dataFlavorArray = new DataFlavor[object.size()];
            object.toArray(dataFlavorArray);
        }
        object = new HashMap(dataFlavorArray.length, 1.0f);
        for (DataFlavor dataFlavor : dataFlavorArray) {
            List<String> list = this.getNativesForFlavor(dataFlavor);
            String string = list.isEmpty() ? null : list.get(0);
            object.put(dataFlavor, string);
        }
        return object;
    }

    @Override
    public synchronized Map<String, DataFlavor> getFlavorsForNatives(String[] stringArray) {
        Object object;
        if (stringArray == null) {
            object = this.getNativesForFlavor(null);
            stringArray = new String[object.size()];
            object.toArray(stringArray);
        }
        object = new HashMap(stringArray.length, 1.0f);
        for (String string : stringArray) {
            List<DataFlavor> list = this.getFlavorsForNative(string);
            DataFlavor dataFlavor = list.isEmpty() ? null : list.get(0);
            object.put(string, dataFlavor);
        }
        return object;
    }

    public synchronized void addUnencodedNativeForFlavor(DataFlavor dataFlavor, String string) {
        Objects.requireNonNull(string, "Null native not permitted");
        Objects.requireNonNull(dataFlavor, "Null flavor not permitted");
        LinkedHashSet<String> linkedHashSet = this.getFlavorToNative().get(dataFlavor);
        if (linkedHashSet == null) {
            linkedHashSet = new LinkedHashSet(1);
            this.getFlavorToNative().put(dataFlavor, linkedHashSet);
        }
        linkedHashSet.add(string);
        this.nativesForFlavorCache.remove(dataFlavor);
    }

    public synchronized void setNativesForFlavor(DataFlavor dataFlavor, String[] stringArray) {
        Objects.requireNonNull(stringArray, "Null natives not permitted");
        Objects.requireNonNull(dataFlavor, "Null flavors not permitted");
        this.getFlavorToNative().remove(dataFlavor);
        for (String string : stringArray) {
            this.addUnencodedNativeForFlavor(dataFlavor, string);
        }
        this.disabledMappingGenerationKeys.add(dataFlavor);
        this.nativesForFlavorCache.remove(dataFlavor);
    }

    public synchronized void addFlavorForUnencodedNative(String string, DataFlavor dataFlavor) {
        Objects.requireNonNull(string, "Null native not permitted");
        Objects.requireNonNull(dataFlavor, "Null flavor not permitted");
        LinkedHashSet<DataFlavor> linkedHashSet = this.getNativeToFlavor().get(string);
        if (linkedHashSet == null) {
            linkedHashSet = new LinkedHashSet(1);
            this.getNativeToFlavor().put(string, linkedHashSet);
        }
        linkedHashSet.add(dataFlavor);
        this.flavorsForNativeCache.remove(string);
    }

    public synchronized void setFlavorsForNative(String string, DataFlavor[] dataFlavorArray) {
        Objects.requireNonNull(string, "Null native not permitted");
        Objects.requireNonNull(dataFlavorArray, "Null flavors not permitted");
        this.getNativeToFlavor().remove(string);
        for (DataFlavor dataFlavor : dataFlavorArray) {
            this.addFlavorForUnencodedNative(string, dataFlavor);
        }
        this.disabledMappingGenerationKeys.add(string);
        this.flavorsForNativeCache.remove(string);
    }

    public static String encodeJavaMIMEType(String string) {
        return string != null ? JavaMIME + string : null;
    }

    public static String encodeDataFlavor(DataFlavor dataFlavor) {
        return dataFlavor != null ? SystemFlavorMap.encodeJavaMIMEType(dataFlavor.getMimeType()) : null;
    }

    public static boolean isJavaMIMEType(String string) {
        return string != null && string.startsWith(JavaMIME, 0);
    }

    public static String decodeJavaMIMEType(String string) {
        return SystemFlavorMap.isJavaMIMEType(string) ? string.substring(JavaMIME.length(), string.length()).trim() : null;
    }

    public static DataFlavor decodeDataFlavor(String string) throws ClassNotFoundException {
        String string2 = SystemFlavorMap.decodeJavaMIMEType(string);
        return string2 != null ? new DataFlavor(string2) : null;
    }

    private static final class SoftCache<K, V> {
        Map<K, SoftReference<LinkedHashSet<V>>> cache;

        private SoftCache() {
        }

        public void put(K k, LinkedHashSet<V> linkedHashSet) {
            if (this.cache == null) {
                this.cache = new HashMap<K, SoftReference<LinkedHashSet<V>>>(1);
            }
            this.cache.put(k, new SoftReference<LinkedHashSet<V>>(linkedHashSet));
        }

        public void remove(K k) {
            if (this.cache == null) {
                return;
            }
            this.cache.remove(null);
            this.cache.remove(k);
        }

        public LinkedHashSet<V> check(K k) {
            if (this.cache == null) {
                return null;
            }
            SoftReference<LinkedHashSet<V>> softReference = this.cache.get(k);
            if (softReference != null) {
                return softReference.get();
            }
            return null;
        }
    }
}

