/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth;

import java.io.Serializable;
import java.security.Principal;
import java.text.MessageFormat;
import jdk.Exported;
import sun.security.util.ResourcesMgr;

@Exported
public class UnixNumericGroupPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 3941535899328403223L;
    private String name;
    private boolean primaryGroup;

    public UnixNumericGroupPrincipal(String string, boolean bl) {
        if (string == null) {
            MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("invalid.null.input.value", "sun.security.util.AuthResources"));
            Object[] objectArray = new Object[]{"name"};
            throw new NullPointerException(messageFormat.format(objectArray));
        }
        this.name = string;
        this.primaryGroup = bl;
    }

    public UnixNumericGroupPrincipal(long l, boolean bl) {
        this.name = new Long(l).toString();
        this.primaryGroup = bl;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public long longValue() {
        return new Long(this.name);
    }

    public boolean isPrimaryGroup() {
        return this.primaryGroup;
    }

    @Override
    public String toString() {
        if (this.primaryGroup) {
            MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("UnixNumericGroupPrincipal.Primary.Group.name", "sun.security.util.AuthResources"));
            Object[] objectArray = new Object[]{this.name};
            return messageFormat.format(objectArray);
        }
        MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("UnixNumericGroupPrincipal.Supplementary.Group.name", "sun.security.util.AuthResources"));
        Object[] objectArray = new Object[]{this.name};
        return messageFormat.format(objectArray);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof UnixNumericGroupPrincipal)) {
            return false;
        }
        UnixNumericGroupPrincipal unixNumericGroupPrincipal = (UnixNumericGroupPrincipal)object;
        return this.getName().equals(unixNumericGroupPrincipal.getName()) && this.isPrimaryGroup() == unixNumericGroupPrincipal.isPrimaryGroup();
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }
}

