/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapReferralException;
import com.sun.jndi.ldap.LdapURL;
import com.sun.jndi.ldap.ReferralEnumeration;
import com.sun.jndi.toolkit.dir.SearchFilter;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;
import javax.naming.spi.NamingManager;

final class LdapReferralContext
implements DirContext,
LdapContext {
    private DirContext refCtx = null;
    private Name urlName = null;
    private String urlAttrs = null;
    private String urlScope = null;
    private String urlFilter = null;
    private LdapReferralException refEx = null;
    private boolean skipThisReferral = false;
    private int hopCount = 1;
    private NamingException previousEx = null;

    LdapReferralContext(LdapReferralException ldapReferralException, Hashtable<?, ?> hashtable, Control[] controlArray, Control[] controlArray2, String string, boolean bl, int n) throws NamingException {
        Object object;
        String string2;
        Object object2;
        this.refEx = ldapReferralException;
        this.skipThisReferral = bl;
        if (this.skipThisReferral) {
            return;
        }
        if (hashtable != null) {
            hashtable = (Hashtable<String, Control[]>)hashtable.clone();
            if (controlArray == null) {
                hashtable.remove("java.naming.ldap.control.connect");
            }
        } else if (controlArray != null) {
            hashtable = new Hashtable<String, Control[]>(5);
        }
        if (controlArray != null) {
            object2 = new Control[controlArray.length];
            System.arraycopy(controlArray, 0, object2, 0, controlArray.length);
            hashtable.put("java.naming.ldap.control.connect", (Control[])object2);
        }
        while (true) {
            try {
                string2 = this.refEx.getNextReferral();
                if (string2 == null) {
                    throw (NamingException)this.previousEx.fillInStackTrace();
                }
            }
            catch (LdapReferralException ldapReferralException2) {
                if (n == 2) {
                    throw ldapReferralException2;
                }
                this.refEx = ldapReferralException2;
                continue;
            }
            object2 = new Reference("javax.naming.directory.DirContext", new StringRefAddr("URL", string2));
            try {
                object = NamingManager.getObjectInstance(object2, null, null, hashtable);
            }
            catch (NamingException namingException) {
                if (n == 2) {
                    throw namingException;
                }
                this.previousEx = namingException;
                continue;
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException("problem generating object using object factory");
                namingException.setRootCause(exception);
                throw namingException;
            }
            break;
        }
        if (object instanceof DirContext) {
            this.refCtx = (DirContext)object;
            if (this.refCtx instanceof LdapContext && controlArray2 != null) {
                ((LdapContext)this.refCtx).setRequestControls(controlArray2);
            }
        } else {
            NotContextException notContextException = new NotContextException("Cannot create context for: " + string2);
            notContextException.setRemainingName(new CompositeName().add(string));
            throw notContextException;
        }
        this.initDefaults(string2, string);
    }

    private void initDefaults(String string, String string2) throws NamingException {
        String string3;
        try {
            LdapURL ldapURL = new LdapURL(string);
            string3 = ldapURL.getDN();
            this.urlAttrs = ldapURL.getAttributes();
            this.urlScope = ldapURL.getScope();
            this.urlFilter = ldapURL.getFilter();
        }
        catch (NamingException namingException) {
            string3 = string;
            this.urlFilter = null;
            this.urlScope = null;
            this.urlAttrs = null;
        }
        string3 = string3 == null ? string2 : "";
        this.urlName = string3 == null ? null : (string3.equals("") ? new CompositeName() : new CompositeName().add(string3));
    }

    @Override
    public void close() throws NamingException {
        if (this.refCtx != null) {
            this.refCtx.close();
            this.refCtx = null;
        }
        this.refEx = null;
    }

    void setHopCount(int n) {
        this.hopCount = n;
        if (this.refCtx != null && this.refCtx instanceof LdapCtx) {
            ((LdapCtx)this.refCtx).setHopCount(n);
        }
    }

    @Override
    public Object lookup(String string) throws NamingException {
        return this.lookup(this.toName(string));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.lookup(this.overrideName(name));
    }

    @Override
    public void bind(String string, Object object) throws NamingException {
        this.bind(this.toName(string), object);
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.bind(this.overrideName(name), object);
    }

    @Override
    public void rebind(String string, Object object) throws NamingException {
        this.rebind(this.toName(string), object);
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.rebind(this.overrideName(name), object);
    }

    @Override
    public void unbind(String string) throws NamingException {
        this.unbind(this.toName(string));
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.unbind(this.overrideName(name));
    }

    @Override
    public void rename(String string, String string2) throws NamingException {
        this.rename(this.toName(string), this.toName(string2));
    }

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.rename(this.overrideName(name), this.toName(this.refEx.getNewRdn()));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String string) throws NamingException {
        return this.list(this.toName(string));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = null;
            if (this.urlScope != null && this.urlScope.equals("base")) {
                SearchControls searchControls = new SearchControls();
                searchControls.setReturningObjFlag(true);
                searchControls.setSearchScope(0);
                namingEnumeration = this.refCtx.search(this.overrideName(name), "(objectclass=*)", searchControls);
            } else {
                namingEnumeration = this.refCtx.list(this.overrideName(name));
            }
            this.refEx.setNameResolved(true);
            ((ReferralEnumeration)namingEnumeration).appendUnprocessedReferrals(this.refEx);
            return namingEnumeration;
        }
        catch (LdapReferralException ldapReferralException) {
            ldapReferralException.appendUnprocessedReferrals(this.refEx);
            throw (NamingException)ldapReferralException.fillInStackTrace();
        }
        catch (NamingException namingException) {
            if (this.refEx != null && !this.refEx.hasMoreReferrals()) {
                this.refEx.setNamingException(namingException);
            }
            if (this.refEx != null && (this.refEx.hasMoreReferrals() || this.refEx.hasMoreReferralExceptions())) {
                throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
            }
            throw namingException;
        }
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String string) throws NamingException {
        return this.listBindings(this.toName(string));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        try {
            NamingEnumeration<Binding> namingEnumeration = null;
            if (this.urlScope != null && this.urlScope.equals("base")) {
                SearchControls searchControls = new SearchControls();
                searchControls.setReturningObjFlag(true);
                searchControls.setSearchScope(0);
                namingEnumeration = this.refCtx.search(this.overrideName(name), "(objectclass=*)", searchControls);
            } else {
                namingEnumeration = this.refCtx.listBindings(this.overrideName(name));
            }
            this.refEx.setNameResolved(true);
            ((ReferralEnumeration)namingEnumeration).appendUnprocessedReferrals(this.refEx);
            return namingEnumeration;
        }
        catch (LdapReferralException ldapReferralException) {
            ldapReferralException.appendUnprocessedReferrals(this.refEx);
            throw (NamingException)ldapReferralException.fillInStackTrace();
        }
        catch (NamingException namingException) {
            if (this.refEx != null && !this.refEx.hasMoreReferrals()) {
                this.refEx.setNamingException(namingException);
            }
            if (this.refEx != null && (this.refEx.hasMoreReferrals() || this.refEx.hasMoreReferralExceptions())) {
                throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
            }
            throw namingException;
        }
    }

    @Override
    public void destroySubcontext(String string) throws NamingException {
        this.destroySubcontext(this.toName(string));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.destroySubcontext(this.overrideName(name));
    }

    @Override
    public Context createSubcontext(String string) throws NamingException {
        return this.createSubcontext(this.toName(string));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.createSubcontext(this.overrideName(name));
    }

    @Override
    public Object lookupLink(String string) throws NamingException {
        return this.lookupLink(this.toName(string));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.lookupLink(this.overrideName(name));
    }

    @Override
    public NameParser getNameParser(String string) throws NamingException {
        return this.getNameParser(this.toName(string));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.getNameParser(this.overrideName(name));
    }

    @Override
    public String composeName(String string, String string2) throws NamingException {
        return this.composeName(this.toName(string), this.toName(string2)).toString();
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.composeName(name, name2);
    }

    @Override
    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.addToEnvironment(string, object);
    }

    @Override
    public Object removeFromEnvironment(String string) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.removeFromEnvironment(string);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.getEnvironment();
    }

    @Override
    public Attributes getAttributes(String string) throws NamingException {
        return this.getAttributes(this.toName(string));
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.getAttributes(this.overrideName(name));
    }

    @Override
    public Attributes getAttributes(String string, String[] stringArray) throws NamingException {
        return this.getAttributes(this.toName(string), stringArray);
    }

    @Override
    public Attributes getAttributes(Name name, String[] stringArray) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.getAttributes(this.overrideName(name), stringArray);
    }

    @Override
    public void modifyAttributes(String string, int n, Attributes attributes) throws NamingException {
        this.modifyAttributes(this.toName(string), n, attributes);
    }

    @Override
    public void modifyAttributes(Name name, int n, Attributes attributes) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.modifyAttributes(this.overrideName(name), n, attributes);
    }

    @Override
    public void modifyAttributes(String string, ModificationItem[] modificationItemArray) throws NamingException {
        this.modifyAttributes(this.toName(string), modificationItemArray);
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] modificationItemArray) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.modifyAttributes(this.overrideName(name), modificationItemArray);
    }

    @Override
    public void bind(String string, Object object, Attributes attributes) throws NamingException {
        this.bind(this.toName(string), object, attributes);
    }

    @Override
    public void bind(Name name, Object object, Attributes attributes) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.bind(this.overrideName(name), object, attributes);
    }

    @Override
    public void rebind(String string, Object object, Attributes attributes) throws NamingException {
        this.rebind(this.toName(string), object, attributes);
    }

    @Override
    public void rebind(Name name, Object object, Attributes attributes) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.rebind(this.overrideName(name), object, attributes);
    }

    @Override
    public DirContext createSubcontext(String string, Attributes attributes) throws NamingException {
        return this.createSubcontext(this.toName(string), attributes);
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attributes) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.createSubcontext(this.overrideName(name), attributes);
    }

    @Override
    public DirContext getSchema(String string) throws NamingException {
        return this.getSchema(this.toName(string));
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.getSchema(this.overrideName(name));
    }

    @Override
    public DirContext getSchemaClassDefinition(String string) throws NamingException {
        return this.getSchemaClassDefinition(this.toName(string));
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.getSchemaClassDefinition(this.overrideName(name));
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, Attributes attributes) throws NamingException {
        return this.search(this.toName(string), SearchFilter.format(attributes), new SearchControls());
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes attributes) throws NamingException {
        return this.search(name, SearchFilter.format(attributes), new SearchControls());
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, Attributes attributes, String[] stringArray) throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(stringArray);
        return this.search(this.toName(string), SearchFilter.format(attributes), searchControls);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes attributes, String[] stringArray) throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(stringArray);
        return this.search(name, SearchFilter.format(attributes), searchControls);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, String string2, SearchControls searchControls) throws NamingException {
        return this.search(this.toName(string), string2, searchControls);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String string, SearchControls searchControls) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        try {
            NamingEnumeration<SearchResult> namingEnumeration = this.refCtx.search(this.overrideName(name), this.overrideFilter(string), this.overrideAttributesAndScope(searchControls));
            this.refEx.setNameResolved(true);
            ((ReferralEnumeration)namingEnumeration).appendUnprocessedReferrals(this.refEx);
            return namingEnumeration;
        }
        catch (LdapReferralException ldapReferralException) {
            ldapReferralException.appendUnprocessedReferrals(this.refEx);
            throw (NamingException)ldapReferralException.fillInStackTrace();
        }
        catch (NamingException namingException) {
            if (this.refEx != null && !this.refEx.hasMoreReferrals()) {
                this.refEx.setNamingException(namingException);
            }
            if (this.refEx != null && (this.refEx.hasMoreReferrals() || this.refEx.hasMoreReferralExceptions())) {
                throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
            }
            throw namingException;
        }
    }

    @Override
    public NamingEnumeration<SearchResult> search(String string, String string2, Object[] objectArray, SearchControls searchControls) throws NamingException {
        return this.search(this.toName(string), string2, objectArray, searchControls);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String string, Object[] objectArray, SearchControls searchControls) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        try {
            NamingEnumeration<SearchResult> namingEnumeration = this.urlFilter != null ? this.refCtx.search(this.overrideName(name), this.urlFilter, this.overrideAttributesAndScope(searchControls)) : this.refCtx.search(this.overrideName(name), string, objectArray, this.overrideAttributesAndScope(searchControls));
            this.refEx.setNameResolved(true);
            ((ReferralEnumeration)namingEnumeration).appendUnprocessedReferrals(this.refEx);
            return namingEnumeration;
        }
        catch (LdapReferralException ldapReferralException) {
            ldapReferralException.appendUnprocessedReferrals(this.refEx);
            throw (NamingException)ldapReferralException.fillInStackTrace();
        }
        catch (NamingException namingException) {
            if (this.refEx != null && !this.refEx.hasMoreReferrals()) {
                this.refEx.setNamingException(namingException);
            }
            if (this.refEx != null && (this.refEx.hasMoreReferrals() || this.refEx.hasMoreReferralExceptions())) {
                throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
            }
            throw namingException;
        }
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.urlName != null && !this.urlName.isEmpty() ? this.urlName.get(0) : "";
    }

    @Override
    public ExtendedResponse extendedOperation(ExtendedRequest extendedRequest) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        if (!(this.refCtx instanceof LdapContext)) {
            throw new NotContextException("Referral context not an instance of LdapContext");
        }
        return ((LdapContext)this.refCtx).extendedOperation(extendedRequest);
    }

    @Override
    public LdapContext newInstance(Control[] controlArray) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        if (!(this.refCtx instanceof LdapContext)) {
            throw new NotContextException("Referral context not an instance of LdapContext");
        }
        return ((LdapContext)this.refCtx).newInstance(controlArray);
    }

    @Override
    public void reconnect(Control[] controlArray) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        if (!(this.refCtx instanceof LdapContext)) {
            throw new NotContextException("Referral context not an instance of LdapContext");
        }
        ((LdapContext)this.refCtx).reconnect(controlArray);
    }

    @Override
    public Control[] getConnectControls() throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        if (!(this.refCtx instanceof LdapContext)) {
            throw new NotContextException("Referral context not an instance of LdapContext");
        }
        return ((LdapContext)this.refCtx).getConnectControls();
    }

    @Override
    public void setRequestControls(Control[] controlArray) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        if (!(this.refCtx instanceof LdapContext)) {
            throw new NotContextException("Referral context not an instance of LdapContext");
        }
        ((LdapContext)this.refCtx).setRequestControls(controlArray);
    }

    @Override
    public Control[] getRequestControls() throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        if (!(this.refCtx instanceof LdapContext)) {
            throw new NotContextException("Referral context not an instance of LdapContext");
        }
        return ((LdapContext)this.refCtx).getRequestControls();
    }

    @Override
    public Control[] getResponseControls() throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        if (!(this.refCtx instanceof LdapContext)) {
            throw new NotContextException("Referral context not an instance of LdapContext");
        }
        return ((LdapContext)this.refCtx).getResponseControls();
    }

    private Name toName(String string) throws InvalidNameException {
        return string.equals("") ? new CompositeName() : new CompositeName().add(string);
    }

    private Name overrideName(Name name) throws InvalidNameException {
        return this.urlName == null ? name : this.urlName;
    }

    private SearchControls overrideAttributesAndScope(SearchControls searchControls) {
        if (this.urlScope != null || this.urlAttrs != null) {
            SearchControls searchControls2 = new SearchControls(searchControls.getSearchScope(), searchControls.getCountLimit(), searchControls.getTimeLimit(), searchControls.getReturningAttributes(), searchControls.getReturningObjFlag(), searchControls.getDerefLinkFlag());
            if (this.urlScope != null) {
                if (this.urlScope.equals("base")) {
                    searchControls2.setSearchScope(0);
                } else if (this.urlScope.equals("one")) {
                    searchControls2.setSearchScope(1);
                } else if (this.urlScope.equals("sub")) {
                    searchControls2.setSearchScope(2);
                }
            }
            if (this.urlAttrs != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.urlAttrs, ",");
                int n = stringTokenizer.countTokens();
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = stringTokenizer.nextToken();
                }
                searchControls2.setReturningAttributes(stringArray);
            }
            return searchControls2;
        }
        return searchControls;
    }

    private String overrideFilter(String string) {
        return this.urlFilter == null ? string : this.urlFilter;
    }
}

