/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.jiagu.bsdiff;

import com.qihoo.jiagu.bsdiff.SearchResult;

public class SuffixSort {
    public static void qsufsort(int[] I, int[] V, byte[] data) {
        int[] buckets = new int[256];
        int i = 0;
        while (i < data.length) {
            int n = data[i] & 0xFF;
            buckets[n] = buckets[n] + 1;
            ++i;
        }
        i = 1;
        while (i < 256) {
            int n = i;
            buckets[n] = buckets[n] + buckets[i - 1];
            ++i;
        }
        i = 255;
        while (i > 0) {
            buckets[i] = buckets[i - 1];
            --i;
        }
        buckets[0] = 0;
        i = 0;
        while (i < data.length) {
            int n = data[i] & 0xFF;
            int n2 = buckets[n] + 1;
            buckets[n] = n2;
            I[n2] = i++;
        }
        I[0] = data.length;
        i = 0;
        while (i < data.length) {
            V[i] = buckets[data[i] & 0xFF];
            ++i;
        }
        V[data.length] = 0;
        i = 1;
        while (i < 256) {
            if (buckets[i] == buckets[i - 1] + 1) {
                I[buckets[i]] = -1;
            }
            ++i;
        }
        I[0] = -1;
        int h = 1;
        while (I[0] != -(data.length + 1)) {
            int len = 0;
            i = 0;
            while (i < data.length + 1) {
                if (I[i] < 0) {
                    len -= I[i];
                    i -= I[i];
                    continue;
                }
                if (len != 0) {
                    I[i - len] = -len;
                }
                len = V[I[i]] + 1 - i;
                SuffixSort.split(I, V, i, len, h);
                i += len;
                len = 0;
            }
            if (len != 0) {
                I[i - len] = -len;
            }
            h += h;
        }
        i = 0;
        while (i < data.length + 1) {
            I[V[i]] = i;
            ++i;
        }
    }

    public static void split(int[] I, int[] V, int start, int len, int h) {
        int tmp;
        if (len < 16) {
            int k = start;
            while (k < start + len) {
                int j = 1;
                int x = V[I[k] + h];
                int i = 1;
                while (k + i < start + len) {
                    if (V[I[k + i] + h] < x) {
                        x = V[I[k + i] + h];
                        j = 0;
                    }
                    if (V[I[k + i] + h] == x) {
                        int tmp2 = I[k + j];
                        I[k + j] = I[k + i];
                        I[k + i] = tmp2;
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < j) {
                    V[I[k + i]] = k + j - 1;
                    ++i;
                }
                if (j == 1) {
                    I[k] = -1;
                }
                k += j;
            }
            return;
        }
        int x = V[I[start + len / 2] + h];
        int jj = 0;
        int kk = 0;
        int i = start;
        while (i < start + len) {
            if (V[I[i] + h] < x) {
                ++jj;
            }
            if (V[I[i] + h] == x) {
                ++kk;
            }
            ++i;
        }
        kk += (jj += start);
        i = start;
        int j = 0;
        int k = 0;
        while (i < jj) {
            if (V[I[i] + h] < x) {
                ++i;
                continue;
            }
            if (V[I[i] + h] == x) {
                tmp = I[i];
                I[i] = I[jj + j];
                I[jj + j] = tmp;
                ++j;
                continue;
            }
            tmp = I[i];
            I[i] = I[kk + k];
            I[kk + k] = tmp;
            ++k;
        }
        while (jj + j < kk) {
            if (V[I[jj + j] + h] == x) {
                ++j;
                continue;
            }
            tmp = I[jj + j];
            I[jj + j] = I[kk + k];
            I[kk + k] = tmp;
            ++k;
        }
        if (jj > start) {
            SuffixSort.split(I, V, start, jj - start, h);
        }
        i = 0;
        while (i < kk - jj) {
            V[I[jj + i]] = kk - 1;
            ++i;
        }
        if (jj == kk - 1) {
            I[jj] = -1;
        }
        if (start + len > kk) {
            SuffixSort.split(I, V, kk, start + len - kk, h);
        }
    }

    private static int matchLength(byte[] bytesA, int offsetA, byte[] bytesB, int offsetB) {
        int oldLimit = bytesA.length - offsetA;
        int newLimit = bytesB.length - offsetB;
        int i = 0;
        while (i < oldLimit && i < newLimit) {
            if (bytesA[i + offsetA] != bytesB[i + offsetB]) break;
            ++i;
        }
        return i;
    }

    public static SearchResult search(int[] I, byte[] oldBytes, int oldOffset, byte[] newBytes, int newOffset, int start, int end) {
        if (end - start < 2) {
            int y;
            int x = SuffixSort.matchLength(oldBytes, I[start], newBytes, newOffset);
            if (x > (y = SuffixSort.matchLength(oldBytes, I[end], newBytes, newOffset))) {
                return new SearchResult(x, I[start]);
            }
            return new SearchResult(y, I[end]);
        }
        int center = start + (end - start) / 2;
        if (SuffixSort.compareBytes(oldBytes, I[center], newBytes, newOffset) < 0) {
            return SuffixSort.search(I, oldBytes, 0, newBytes, newOffset, center, end);
        }
        return SuffixSort.search(I, oldBytes, 0, newBytes, newOffset, start, center);
    }

    private static int compareBytes(byte[] bytesA, int offsetA, byte[] bytesB, int offsetB) {
        int length = Math.min(bytesA.length - offsetA, bytesB.length - offsetB);
        int valA = 0;
        int valB = 0;
        int i = 0;
        while (i < length) {
            valA = bytesA[i + offsetA] & 0xFF;
            valB = bytesB[i + offsetB] & 0xFF;
            if (valA != valB) break;
            ++i;
        }
        return valA - valB;
    }
}

