/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beansbinding;

import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.beansbinding.PropertyHelper;
import org.jdesktop.beansbinding.PropertyResolutionException;
import org.jdesktop.beansbinding.PropertyStateEvent;
import org.jdesktop.beansbinding.PropertyStateListener;
import org.jdesktop.beansbinding.TempELContext;
import org.jdesktop.beansbinding.ext.BeanAdapterFactory;
import org.jdesktop.beansbinding.util.logging.Logger;
import org.jdesktop.el.ELContext;
import org.jdesktop.el.ELException;
import org.jdesktop.el.Expression;
import org.jdesktop.el.ValueExpression;
import org.jdesktop.el.impl.ExpressionFactoryImpl;
import org.jdesktop.observablecollections.ObservableMap;
import org.jdesktop.observablecollections.ObservableMapListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ELProperty<S, V>
extends PropertyHelper<S, V> {
    private static final String CLASS = ELProperty.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final Object NOREAD = new Object();
    private Property<S, ?> baseProperty;
    private final ValueExpression expression;
    private final ELContext context = new TempELContext();
    private IdentityHashMap<S, SourceEntry> map = new IdentityHashMap();

    private ELProperty(Property<S, ?> baseProperty, String expression) {
        if (expression == null || expression.length() == 0) {
            throw new IllegalArgumentException("expression must be non-null and non-empty");
        }
        try {
            this.expression = new ExpressionFactoryImpl().createValueExpression(this.context, expression, (Class)Object.class);
        }
        catch (ELException ele) {
            throw new PropertyResolutionException("Error creating EL expression " + expression, ele);
        }
        this.baseProperty = baseProperty;
    }

    public static final <S, V> ELProperty<S, V> create(String expression) {
        return new ELProperty<S, V>(null, expression);
    }

    public static final <S, V> ELProperty<S, V> create(Property<S, ?> baseProperty, String expression) {
        return new ELProperty<S, V>(baseProperty, expression);
    }

    @Override
    public Class<? extends V> getWriteType(S source) {
        SourceEntry entry = this.map.get(source);
        if (entry != null) {
            entry.validateCache(-1);
            if (!entry.cachedIsWriteable) {
                throw new UnsupportedOperationException("Unwriteable");
            }
            return entry.cachedWriteType;
        }
        try {
            this.expression.setSource(this.getBeanFromSource(source, true));
            Expression.Result result = this.expression.getResult(this.context, false);
            if (result.getType() == Expression.Result.Type.UNRESOLVABLE) {
                logger.warning("getWriteType(): expression is unresolvable", new Object[0]);
                throw new UnsupportedOperationException("Unwriteable");
            }
            if (this.expression.isReadOnly(this.context)) {
                logger.warning("getWriteType(): property is unwriteable", new Object[0]);
                throw new UnsupportedOperationException("Unwriteable");
            }
            Class<?> clazz = this.expression.getType(this.context);
            return clazz;
        }
        catch (ELException ele) {
            throw new PropertyResolutionException("Error evaluating EL expression " + this.expression + " on " + source, ele);
        }
        finally {
            this.expression.setSource(null);
        }
    }

    @Override
    public V getValue(S source) {
        SourceEntry entry = this.map.get(source);
        if (entry != null) {
            entry.validateCache(-1);
            if (entry.cachedValue == NOREAD) {
                throw new UnsupportedOperationException("Unreadable");
            }
            return (V)entry.cachedValue;
        }
        try {
            this.expression.setSource(this.getBeanFromSource(source, true));
            Expression.Result result = this.expression.getResult(this.context, false);
            if (result.getType() == Expression.Result.Type.UNRESOLVABLE) {
                logger.warning("getValue(): expression is unresolvable", new Object[0]);
                throw new UnsupportedOperationException("Unreadable");
            }
            Object object = result.getResult();
            return (V)object;
        }
        catch (ELException ele) {
            throw new PropertyResolutionException("Error evaluating EL expression " + this.expression + " on " + source, ele);
        }
        finally {
            this.expression.setSource(null);
        }
    }

    @Override
    public void setValue(S source, V value) {
        SourceEntry entry = this.map.get(source);
        if (entry != null) {
            entry.validateCache(-1);
            if (!entry.cachedIsWriteable) {
                throw new UnsupportedOperationException("Unwritable");
            }
            try {
                entry.ignoreChange = true;
                this.expression.setSource(this.getBeanFromSource(source, false));
                this.expression.setValue(this.context, value);
            }
            catch (ELException ele) {
                throw new PropertyResolutionException("Error evaluating EL expression " + this.expression + " on " + source, ele);
            }
            finally {
                entry.ignoreChange = false;
                this.expression.setSource(null);
            }
            Object oldValue = entry.cachedValue;
            entry.updateCache();
            this.notifyListeners(entry.cachedIsWriteable, oldValue, entry);
            return;
        }
        try {
            this.expression.setSource(this.getBeanFromSource(source, true));
            Expression.Result result = this.expression.getResult(this.context, false);
            if (result.getType() == Expression.Result.Type.UNRESOLVABLE) {
                logger.warning("setValue(): expression is unresolvable", new Object[0]);
                throw new UnsupportedOperationException("Unwriteable");
            }
            if (this.expression.isReadOnly(this.context)) {
                logger.warning("setValue(): property is unwriteable", new Object[0]);
                throw new UnsupportedOperationException("Unwriteable");
            }
            this.expression.setValue(this.context, value);
        }
        catch (ELException ele) {
            throw new PropertyResolutionException("Error evaluating EL expression " + this.expression + " on " + source, ele);
        }
        finally {
            this.expression.setSource(null);
        }
    }

    @Override
    public boolean isReadable(S source) {
        SourceEntry entry = this.map.get(source);
        if (entry != null) {
            entry.validateCache(-1);
            return entry.cachedIsReadable();
        }
        try {
            this.expression.setSource(this.getBeanFromSource(source, true));
            Expression.Result result = this.expression.getResult(this.context, false);
            if (result.getType() == Expression.Result.Type.UNRESOLVABLE) {
                logger.warning("isReadable(): expression is unresolvable", new Object[0]);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (ELException ele) {
            throw new PropertyResolutionException("Error evaluating EL expression " + this.expression + " on " + source, ele);
        }
        finally {
            this.expression.setSource(null);
        }
    }

    @Override
    public boolean isWriteable(S source) {
        SourceEntry entry = this.map.get(source);
        if (entry != null) {
            entry.validateCache(-1);
            return entry.cachedIsWriteable;
        }
        try {
            this.expression.setSource(this.getBeanFromSource(source, true));
            Expression.Result result = this.expression.getResult(this.context, false);
            if (result.getType() == Expression.Result.Type.UNRESOLVABLE) {
                logger.warning("isWriteable(): expression is unresolvable", new Object[0]);
                boolean bl = false;
                return bl;
            }
            if (this.expression.isReadOnly(this.context)) {
                logger.warning("isWriteable(): property is unwriteable", new Object[0]);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (ELException ele) {
            throw new PropertyResolutionException("Error evaluating EL expression " + this.expression + " on " + source, ele);
        }
        finally {
            this.expression.setSource(null);
        }
    }

    private Object getBeanFromSource(S source, boolean logErrors) {
        if (this.baseProperty == null) {
            if (source == null && logErrors) {
                logger.severe("getBeanFromSource(): source is null", new Object[0]);
            }
            return source;
        }
        if (!this.baseProperty.isReadable(source)) {
            if (logErrors) {
                logger.severe("getBeanFromSource(): unreadable source property", new Object[0]);
            }
            return NOREAD;
        }
        Object bean = this.baseProperty.getValue(source);
        if (bean == null) {
            if (logErrors) {
                logger.severe("getBeanFromSource(): source property returned null", new Object[0]);
            }
            return null;
        }
        return bean;
    }

    @Override
    protected final void listeningStarted(S source) {
        SourceEntry entry = this.map.get(source);
        if (entry == null) {
            entry = new SourceEntry(source);
            this.map.put(source, entry);
        }
    }

    @Override
    protected final void listeningStopped(S source) {
        SourceEntry entry = this.map.remove(source);
        if (entry != null) {
            entry.cleanup();
        }
    }

    private static boolean didValueChange(Object oldValue, Object newValue) {
        return oldValue == null || newValue == null || !oldValue.equals(newValue);
    }

    private void notifyListeners(boolean wasWriteable, Object oldValue, SourceEntry entry) {
        boolean writeableChanged;
        PropertyStateListener[] listeners = this.getPropertyStateListeners(entry.source);
        if (listeners == null || listeners.length == 0) {
            return;
        }
        oldValue = ELProperty.toUNREADABLE(oldValue);
        Object newValue = ELProperty.toUNREADABLE(entry.cachedValue);
        boolean valueChanged = ELProperty.didValueChange(oldValue, newValue);
        boolean bl = writeableChanged = wasWriteable != entry.cachedIsWriteable;
        if (!valueChanged && !writeableChanged) {
            return;
        }
        PropertyStateEvent pse = new PropertyStateEvent(this, entry.source, valueChanged, oldValue, newValue, writeableChanged, entry.cachedIsWriteable);
        this.firePropertyStateChange(pse);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.expression + "]";
    }

    private static BeanInfo getBeanInfo(Object object) {
        assert (object != null);
        try {
            return Introspector.getBeanInfo(object.getClass());
        }
        catch (IntrospectionException ie) {
            throw new PropertyResolutionException("Exception while introspecting " + object.getClass().getName(), ie);
        }
    }

    private static EventSetDescriptor getEventSetDescriptor(Object object) {
        EventSetDescriptor[] eds;
        assert (object != null);
        for (EventSetDescriptor ed : eds = ELProperty.getBeanInfo(object).getEventSetDescriptors()) {
            if (ed.getListenerType() != PropertyChangeListener.class) continue;
            return ed;
        }
        return null;
    }

    private static Object invokeMethod(Method method, Object object, Object ... args) {
        Exception reason = null;
        try {
            return method.invoke(object, args);
        }
        catch (IllegalArgumentException ex) {
            reason = ex;
        }
        catch (IllegalAccessException ex) {
            reason = ex;
        }
        catch (InvocationTargetException ex) {
            reason = ex;
        }
        throw new PropertyResolutionException("Exception invoking method " + method + " on " + object, reason);
    }

    private static Object toUNREADABLE(Object src) {
        return src == NOREAD ? PropertyStateEvent.UNREADABLE : src;
    }

    private void registerListener(Expression.ResolvedProperty resolved, SourceEntry entry) {
        Object source = resolved.getSource();
        Object property = resolved.getProperty();
        if (source != null && property instanceof String) {
            String sProp = (String)property;
            if (source instanceof ObservableMap) {
                RegisteredListener rl = new RegisteredListener(source, sProp);
                if (!entry.registeredListeners.contains(rl)) {
                    if (!entry.lastRegisteredListeners.remove(rl)) {
                        ((ObservableMap)source).addObservableMapListener(entry);
                    }
                    entry.registeredListeners.add(rl);
                }
            } else if (!(source instanceof Map)) {
                source = this.getAdapter(source, sProp);
                RegisteredListener rl = new RegisteredListener(source, sProp);
                if (!entry.registeredListeners.contains(rl)) {
                    if (!entry.lastRegisteredListeners.remove(rl)) {
                        ELProperty.addPropertyChangeListener(source, entry);
                    }
                    entry.registeredListeners.add(rl);
                }
            }
        }
    }

    private void unregisterListener(RegisteredListener rl, SourceEntry entry) {
        Object source = rl.getSource();
        if (source instanceof ObservableMap) {
            ((ObservableMap)source).removeObservableMapListener(entry);
        } else if (!(source instanceof Map)) {
            ELProperty.removePropertyChangeListener(source, entry);
        }
    }

    private static void addPropertyChangeListener(Object object, PropertyChangeListener listener) {
        EventSetDescriptor ed = ELProperty.getEventSetDescriptor(object);
        Method addPCMethod = null;
        if (ed == null || (addPCMethod = ed.getAddListenerMethod()) == null) {
            logger.warning("addPropertyChangeListener(): can't add listener", new Object[0]);
            return;
        }
        ELProperty.invokeMethod(addPCMethod, object, listener);
    }

    private static void removePropertyChangeListener(Object object, PropertyChangeListener listener) {
        EventSetDescriptor ed = ELProperty.getEventSetDescriptor(object);
        Method removePCMethod = null;
        if (ed == null || (removePCMethod = ed.getRemoveListenerMethod()) == null) {
            logger.warning("removePropertyChangeListener(): can't remove listener from source", new Object[0]);
            return;
        }
        ELProperty.invokeMethod(removePCMethod, object, listener);
    }

    private Object getAdapter(Object o, String property) {
        Object adapter = null;
        adapter = BeanAdapterFactory.getAdapter(o, property);
        return adapter == null ? o : adapter;
    }

    private static final class RegisteredListener {
        private final Object source;
        private final String property;

        RegisteredListener(Object source) {
            this(source, null);
        }

        RegisteredListener(Object source, String property) {
            this.source = source;
            if (property != null) {
                property = property.intern();
            }
            this.property = property;
        }

        public Object getSource() {
            return this.source;
        }

        public String getProperty() {
            return this.property;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof RegisteredListener) {
                RegisteredListener orl = (RegisteredListener)obj;
                return orl.source == this.source && orl.property == this.property;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.source.hashCode();
            if (this.property != null) {
                result = 37 * result + this.property.hashCode();
            }
            return result;
        }

        public String toString() {
            return "RegisteredListener [ source=" + this.source + " property=" + this.property + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SourceEntry
    implements PropertyChangeListener,
    ObservableMapListener,
    PropertyStateListener {
        private S source;
        private Object cachedBean;
        private Object cachedValue;
        private boolean cachedIsWriteable;
        private Class<?> cachedWriteType;
        private boolean ignoreChange;
        private Set<RegisteredListener> registeredListeners;
        private Set<RegisteredListener> lastRegisteredListeners;

        private SourceEntry(S source) {
            this.source = source;
            if (ELProperty.this.baseProperty != null) {
                ELProperty.this.baseProperty.addPropertyStateListener(source, this);
            }
            this.registeredListeners = new HashSet<RegisteredListener>(1);
            this.updateCachedBean();
            this.updateCache();
        }

        private void cleanup() {
            for (RegisteredListener rl : this.registeredListeners) {
                ELProperty.this.unregisterListener(rl, this);
            }
            if (ELProperty.this.baseProperty != null) {
                ELProperty.this.baseProperty.removePropertyStateListener(this.source, this);
            }
            this.cachedBean = null;
            this.registeredListeners = null;
            this.cachedValue = null;
        }

        private boolean cachedIsReadable() {
            return this.cachedValue != NOREAD;
        }

        private void updateCachedBean() {
            this.cachedBean = ELProperty.this.getBeanFromSource(this.source, true);
        }

        private void updateCache() {
            this.lastRegisteredListeners = this.registeredListeners;
            this.registeredListeners = new HashSet<RegisteredListener>(this.lastRegisteredListeners.size());
            List<Expression.ResolvedProperty> resolvedProperties = null;
            try {
                ELProperty.this.expression.setSource(ELProperty.this.getBeanFromSource(this.source, true));
                Expression.Result result = ELProperty.this.expression.getResult(ELProperty.this.context, true);
                if (result.getType() == Expression.Result.Type.UNRESOLVABLE) {
                    logger.warning("updateCache(): expression is unresolvable", new Object[0]);
                    this.cachedValue = NOREAD;
                    this.cachedIsWriteable = false;
                    this.cachedWriteType = null;
                } else {
                    this.cachedValue = result.getResult();
                    this.cachedIsWriteable = !ELProperty.this.expression.isReadOnly(ELProperty.this.context);
                    this.cachedWriteType = this.cachedIsWriteable ? ELProperty.this.expression.getType(ELProperty.this.context) : null;
                }
                resolvedProperties = result.getResolvedProperties();
            }
            catch (ELException ele) {
                throw new PropertyResolutionException("Error evaluating EL expression " + ELProperty.this.expression + " on " + this.source, ele);
            }
            finally {
                ELProperty.this.expression.setSource(null);
            }
            for (Expression.ResolvedProperty prop : resolvedProperties) {
                ELProperty.this.registerListener(prop, this);
            }
            for (RegisteredListener listener : this.lastRegisteredListeners) {
                ELProperty.this.unregisterListener(listener, this);
            }
            this.lastRegisteredListeners = null;
        }

        private void validateCache(int flag) {
        }

        @Override
        public void propertyStateChanged(PropertyStateEvent pe) {
            if (!pe.getValueChanged()) {
                return;
            }
            this.validateCache(0);
            Object oldValue = this.cachedValue;
            boolean wasWriteable = this.cachedIsWriteable;
            this.updateCachedBean();
            this.updateCache();
            ELProperty.this.notifyListeners(wasWriteable, oldValue, this);
        }

        private void processSourceChanged() {
            this.validateCache(1);
            boolean wasWriteable = this.cachedIsWriteable;
            Object oldValue = this.cachedValue;
            this.updateCache();
            ELProperty.this.notifyListeners(wasWriteable, oldValue, this);
        }

        private void sourceChanged(Object source, String property) {
            if (this.ignoreChange) {
                return;
            }
            if (property != null) {
                property = property.intern();
            }
            for (RegisteredListener rl : this.registeredListeners) {
                if (rl.getSource() != source || property != null && rl.getProperty() != property) continue;
                this.processSourceChanged();
                break;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            this.sourceChanged(e.getSource(), e.getPropertyName());
        }

        @Override
        public void mapKeyValueChanged(ObservableMap map, Object key, Object lastValue) {
            if (key instanceof String) {
                this.sourceChanged(map, (String)key);
            }
        }

        @Override
        public void mapKeyAdded(ObservableMap map, Object key) {
            if (key instanceof String) {
                this.sourceChanged(map, (String)key);
            }
        }

        @Override
        public void mapKeyRemoved(ObservableMap map, Object key, Object value) {
            if (key instanceof String) {
                this.sourceChanged(map, (String)key);
            }
        }
    }
}

