/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.jiagu.bsdiff;

import com.qihoo.jiagu.bsdiff.ControlBlock;
import com.qihoo.jiagu.bsdiff.Header;
import com.qihoo.jiagu.bsdiff.InvalidHeaderException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;

public class Patch {
    public static void patch(byte[] old, byte[] patch, OutputStream out) throws CompressorException, InvalidHeaderException, IOException {
        ByteArrayInputStream headerIn = new ByteArrayInputStream(patch);
        Header header = new Header(headerIn);
        ((InputStream)headerIn).close();
        InputStream controlIn = new ByteArrayInputStream(patch);
        InputStream dataIn = new ByteArrayInputStream(patch);
        InputStream extraIn = new ByteArrayInputStream(patch);
        try {
            try {
                controlIn.skip(32L);
                dataIn.skip(32 + header.getControlLength());
                extraIn.skip(32 + header.getControlLength() + header.getDiffLength());
                CompressorStreamFactory compressor = new CompressorStreamFactory();
                controlIn = compressor.createCompressorInputStream(controlIn);
                dataIn = compressor.createCompressorInputStream(dataIn);
                extraIn = compressor.createCompressorInputStream(extraIn);
                int newPointer = 0;
                int oldPointer = 0;
                byte[] output = new byte[header.getOutputLength()];
                while (newPointer < output.length) {
                    ControlBlock control = new ControlBlock(controlIn);
                    Patch.read(dataIn, output, newPointer, control.getDiffLength());
                    int i = 0;
                    while (i < control.getDiffLength()) {
                        if (oldPointer + i >= 0 && oldPointer + i < old.length) {
                            int n = newPointer + i;
                            output[n] = (byte)(output[n] + old[oldPointer + i]);
                        }
                        ++i;
                    }
                    oldPointer += control.getDiffLength();
                    Patch.read(extraIn, output, newPointer += control.getDiffLength(), control.getExtraLength());
                    newPointer += control.getExtraLength();
                    oldPointer += control.getSeekLength();
                }
                out.write(output);
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    controlIn.close();
                    dataIn.close();
                    extraIn.close();
                }
            }
        }
        finally {
            controlIn.close();
            dataIn.close();
            extraIn.close();
        }
    }

    private static void read(InputStream in, byte[] dest, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        int read = in.read(dest, off, len);
        if (read < len) {
            throw new IOException("Corrupt patch; bytes expected = " + len + " bytes read = " + read);
        }
    }
}

