/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksigner;

import java.io.ByteArrayOutputStream;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PasswordRetriever
implements AutoCloseable {
    public static final String SPEC_STDIN = "stdin";
    private static final Charset CONSOLE_CHARSET = PasswordRetriever.getConsoleEncoding();
    private final Map<File, InputStream> mFileInputStreams = new HashMap<File, InputStream>();
    private boolean mClosed;

    PasswordRetriever() {
    }

    public List<char[]> getPasswords(String spec, String description) throws IOException {
        this.assertNotClosed();
        if (spec.startsWith("pass:")) {
            char[] pwd = spec.substring("pass:".length()).toCharArray();
            return PasswordRetriever.getPasswords(pwd);
        }
        if (SPEC_STDIN.equals(spec)) {
            Console console = System.console();
            if (console != null) {
                char[] pwd = console.readPassword(description + ": ", new Object[0]);
                if (pwd == null) {
                    throw new IOException("Failed to read " + description + ": console closed");
                }
                return PasswordRetriever.getPasswords(pwd);
            }
            System.out.println(description + ": ");
            byte[] encodedPwd = PasswordRetriever.readEncodedPassword(System.in);
            if (encodedPwd.length == 0) {
                throw new IOException("Failed to read " + description + ": standard input closed");
            }
            return PasswordRetriever.getPasswords(encodedPwd, Charset.defaultCharset(), CONSOLE_CHARSET);
        }
        if (spec.startsWith("file:")) {
            byte[] encodedPwd;
            String name = spec.substring("file:".length());
            File file = new File(name).getCanonicalFile();
            InputStream in = this.mFileInputStreams.get(file);
            if (in == null) {
                in = new FileInputStream(file);
                this.mFileInputStreams.put(file, in);
            }
            if ((encodedPwd = PasswordRetriever.readEncodedPassword(in)).length == 0) {
                throw new IOException("Failed to read " + description + " : end of file reached in " + file);
            }
            return PasswordRetriever.getPasswords(encodedPwd, Charset.defaultCharset());
        }
        if (spec.startsWith("env:")) {
            String name = spec.substring("env:".length());
            String value = System.getenv(name);
            if (value == null) {
                throw new IOException("Failed to read " + description + ": environment variable " + value + " not specified");
            }
            return PasswordRetriever.getPasswords(value.toCharArray());
        }
        throw new IOException("Unsupported password spec for " + description + ": " + spec);
    }

    private static List<char[]> getPasswords(char[] pwd) {
        ArrayList<char[]> passwords = new ArrayList<char[]>(3);
        PasswordRetriever.addPasswords(passwords, pwd);
        return passwords;
    }

    private static List<char[]> getPasswords(byte[] encodedPwd, Charset ... encodings) {
        ArrayList<char[]> passwords = new ArrayList<char[]>(4);
        for (Charset encoding : encodings) {
            try {
                char[] pwd = PasswordRetriever.decodePassword(encodedPwd, encoding);
                PasswordRetriever.addPasswords(passwords, pwd);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        PasswordRetriever.addPassword(passwords, PasswordRetriever.castBytesToChars(encodedPwd));
        return passwords;
    }

    private static void addPasswords(List<char[]> passwords, char[] pwd) {
        char[] encodedPwd2;
        PasswordRetriever.addPassword(passwords, pwd);
        try {
            encodedPwd2 = PasswordRetriever.castBytesToChars(PasswordRetriever.encodePassword(pwd, Charset.defaultCharset()));
            PasswordRetriever.addPassword(passwords, encodedPwd2);
        }
        catch (IOException encodedPwd2) {
            // empty catch block
        }
        if (!CONSOLE_CHARSET.equals(Charset.defaultCharset())) {
            try {
                encodedPwd2 = PasswordRetriever.castBytesToChars(PasswordRetriever.encodePassword(pwd, CONSOLE_CHARSET));
                PasswordRetriever.addPassword(passwords, encodedPwd2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void addPassword(List<char[]> passwords, char[] password) {
        for (char[] existingPassword : passwords) {
            if (!Arrays.equals(password, existingPassword)) continue;
            return;
        }
        passwords.add(password);
    }

    private static byte[] encodePassword(char[] pwd, Charset cs) throws IOException {
        ByteBuffer pwdBytes = cs.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).encode(CharBuffer.wrap(pwd));
        byte[] encoded = new byte[pwdBytes.remaining()];
        pwdBytes.get(encoded);
        return encoded;
    }

    private static char[] decodePassword(byte[] pwdBytes, Charset encoding) throws IOException {
        CharBuffer pwdChars = encoding.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).decode(ByteBuffer.wrap(pwdBytes));
        char[] result = new char[pwdChars.remaining()];
        pwdChars.get(result);
        return result;
    }

    private static char[] castBytesToChars(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        char[] chars = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            chars[i] = (char)(bytes[i] & 0xFF);
        }
        return chars;
    }

    private static Charset getConsoleEncoding() {
        String consoleCharsetName;
        try {
            Method encodingMethod = Console.class.getDeclaredMethod("encoding", new Class[0]);
            encodingMethod.setAccessible(true);
            consoleCharsetName = (String)encodingMethod.invoke(null, new Object[0]);
            if (consoleCharsetName == null) {
                return Charset.defaultCharset();
            }
        }
        catch (ReflectiveOperationException e) {
            Charset defaultCharset = Charset.defaultCharset();
            System.err.println("warning: Failed to obtain console character encoding name. Assuming " + defaultCharset);
            return defaultCharset;
        }
        try {
            return Charset.forName(consoleCharsetName);
        }
        catch (IllegalArgumentException e) {
            if ("cp65001".equals(consoleCharsetName)) {
                return StandardCharsets.UTF_8;
            }
            Charset defaultCharset = Charset.defaultCharset();
            System.err.println("warning: Console uses unknown character encoding: " + consoleCharsetName + ". Using " + defaultCharset + " instead");
            return defaultCharset;
        }
    }

    private static byte[] readEncodedPassword(InputStream in) throws IOException {
        int b;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        while ((b = in.read()) != -1 && b != 10) {
            if (b == 13) {
                int next = in.read();
                if (next == -1 || next == 10) break;
                if (!(in instanceof PushbackInputStream)) {
                    in = new PushbackInputStream(in);
                }
                ((PushbackInputStream)in).unread(next);
            }
            result.write(b);
        }
        return result.toByteArray();
    }

    private void assertNotClosed() {
        if (this.mClosed) {
            throw new IllegalStateException("Closed");
        }
    }

    @Override
    public void close() {
        for (InputStream in : this.mFileInputStreams.values()) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        this.mFileInputStreams.clear();
        this.mClosed = true;
    }
}

