const path = require('path');
const HtmlWebpackPlugin = require('html-webpack-plugin');

module.exports = {
  entry: path.resolve(__dirname, 'src/index.js'),
  mode: 'development',
  output: {
    path: path.resolve(__dirname, 'dist'),
    filename: '[name].js',
    sourceMapFilename: '[name].js.map',
  },
  devtool: 'source-map',
  devServer: {
    hot: true,
    host: 'localhost',
    port: '8000',
    open: true,
  },
  module: {
    rules: [
      {
        test: /\.js$/,
        use: [require.resolve('babel-loader')],
      },
    ],
  },
  plugins: [
    new HtmlWebpackPlugin({
      template: path.resolve(__dirname, 'index.html'),
      inject: true,
    }),
  ],
};
