import random from 'lodash/random';
import * as Sentry from '@sentry/browser';

Sentry.init({
  dsn: 'https://c043ba03536a41bfb87d122984fa3e15@sentry.dui88.com/15',
});

const rd = random();

const appDom = document.getElementById('app');
appDom.innerHTML = `<button id="btn">点击记录 breadcrumb</button><button id="errorBtn">errorBtn</button>`;

document.getElementById('btn').onclick = () => {
  Sentry.addBreadcrumb({
    category: 'user.click',
    message: '点击btn',
    level: Sentry.Severity.Info,
    data: { uid: 100 },
  });
};
document.getElementById('errorBtn').onclick = () => {
  const err = new Error('errorBtn 发生了错误');
  Sentry.captureException(err);
};
