import { start, Weixin, WeixinMini, NingboBank, updateShare, callShare, showShareGuide } from '@spark/share'
export {
    InitWxShare,
    InitWxMiniShare,
    UpdateWxShare,
    InitAppShare,
    CallAppShare,
    ShowShareGuide
}

/**
 * 设置分享动态域名链接
 */
async function setShareUrl() {
    const domain = await window.dbdomain?.getDomain().catch(err => console.warn('动态域名err', err));
    console.warn('动态域名', domain);
    CFG.shareConfig.url = `${domain}/projectx/${CFG.projectId}/shareLanding.html?appID=${CFG.appID}`
}

/**
 * 微信分享初始化
 * @param {{}} shareConfig 分享配置
 */
function InitWxShare(shareConfig) {
    return new Promise(async resolve => {
        await setShareUrl();
        start([Weixin]).then(() => {
            updateShare(shareConfig);
            resolve(true);
        }).catch(err => {
            console.warn('分享初始化失败', err);
            resolve(false);
        })
    })
}
/**
 * 微信小程序分享初始化
 */
function InitWxMiniShare(shareConfig) {
    return new Promise(async resolve => {
        await setShareUrl();
        start([WeixinMini]).then(() => {
            updateShare(shareConfig);
            resolve(true);
        }).catch(err => {
            console.warn('分享初始化失败', err);
            resolve(false);
        })
    })
}
/** 更新微信分享配置 */
const UpdateWxShare = updateShare;
/**分享引导蒙层 */
const ShowShareGuide = showShareGuide;

/**
 * app分享初始化
 */
function InitAppShare() {
    return new Promise(async resolve => {
        await setShareUrl();
        start([NingboBank], (way, success, payload) => {
            resolve(true)
            console.warn('app分享' + success ? '成功' : '失败')
        })
    })
}
/** 唤起app分享 */
const CallAppShare = callShare;