'use strict';

import React, { Component } from 'react';
import { Global } from '@src/global';
import { SceneId } from '@src/constant';
import Rule_for_test from "../../components/rule_for_test/comp";
import './comp.less';
import AssetList from '../../assetList.json'
import { Comp_fyge_canvas, createImg, createSvga, createLottie, createSpine } from '@src/components/comp_fyge_canvas/comp';

class Scene_test extends Component {

  onStageReady = async (stage) => {
    Global.assetData = await Global.PreloadAsset(AssetList.preloadAsset, 10, (progress) => {});
    // console.log('Global.assetData', Global.assetData['loadTime']);
    stage.addChildren(
      createSpine({
        path: 'test/cow_spine.spi', x: 400, y: 600, skinName: '4级', aniName: '开心', autoPlay: true, onCreated: spine => {
          console.warn('spine11111=', spine);
        }
      })
    )
  }

  /**
   * 播放音频
   * @param {object} option 
   */
  playAudio = ({ path, volume = 1, loop = false }) => {
    const audio = Global.assetData[path];
    console.warn('audio', audio);
    audio.volume(volume);
    audio.loop(loop);
    audio.play();
    return audio
  }

  render() {
    return (
      <div className="container" >
        <Comp_fyge_canvas onStageReady={this.onStageReady} />
        <div className="scroll_view">
          <div className="for_click" onClick={() => Global.showPop({ popName: Rule_for_test, isClickBlankHide: true })}>弹窗测试</div>
        </div>
      </div>
    );
  }
}

export default Scene_test;
