"use strict";

import React, { Component } from "react";
import { SceneId } from "@src/constant";
import { Global } from "@src/global";
import "./comp.less";
import Scene_test from "../scene_test/comp";
import AssetList from "../../assetList.json";
import { Loading } from "@spark/ui";
class Page_index extends Component {
  state = {
    sceneId: SceneId.MAIN, // 场景id
    sceneData: null, // 场景参数
    show: false,
  };

  async componentDidMount() {
    Global.switchScene = this.switchScene;
    Global.assetData = await Global.PreloadAsset(
      AssetList.preloadAsset,
      10,
      (progress) => {}
    );
    setTimeout(() => {
      this.setState({
        show: true,
      });
    }, Global.assetData["loadTime"]);
  }

  /**
   * 切换场景
   * @param {number} sceneId 场景id
   * @param {*} sceneData 场景参数
   */
  switchScene = (sceneId, sceneData = null) => {
    this.setState({ sceneId, sceneData });
  };

  render() {
    const { sceneId, sceneData, show } = this.state;
    return (
      <>
        {show ? <Scene_test sceneData={sceneData} /> : <>{<span>123</span>}</>}
        {/* {sceneId == SceneId.MAIN && <Scene_test sceneData={sceneData} />} */}
        {/* {sceneId == SceneId.MAIN && <Scene_test sceneData={sceneData} />} */}
      </>
    );
  }
}

export default Page_index;
