import { Toast } from '@spark/ui'
import { generateAPI } from '../api/index'
export { Itoast, BenchAPI, }

// 自动添加一些wrap.js用到的样式
(function autoAddStyle() {
    const ICSS = `
        .self_toast_item {
            border-radius: 0.2rem !important;
            background-color: rgba(0,0,0,0.75) !important;
        }
        .self_toast_content {
            padding: 0.25rem 0.6rem !important;
        }
    `
    const style = document.createElement('style');
    style.innerHTML = ICSS;
    document.getElementsByTagName('head')[0].appendChild(style);
})()

/**
 * Toast包装后的：优化了样式，一个toast时间内不会再出其它toast
 * @param {*} content 内容
 * @param {number} time 停留时间
 */
function Itoast(content, time = 1200) {
    return Toast(content, time, { itemClass: 'self_toast_item', contentClass: 'self_toast_content', hideOthers: true })
}

/**
 * 替补API
 * @param {{}} options 请求配置
 * @param {{}} [params] 请求参数
 * @return {Promise} 请求结果Promise;
 */
function BenchAPI(options, params = {}) {
    const API = generateAPI({ benchName: options });
    return API.benchName(params);
}




