export { SendLog };

/**
 * 发送埋点
 * @description
 * dpm传后两位即可（如'appID.110.1.1'，传'1.1'即可），会自动拼上window.CFG里写入appID和projectId，也可以手动传入appID和projectId
 * @param {object} data 埋点参数
 * @param {string} data.type 埋点类型 exposure: 曝光 | click: 点击
 * @param {string} data.dpm dpm后两位
 * @param {string} [data.dcm] dcm
 * @param {string} [data.dom] dom
 * @param {string} [data.appID] appID
 * @param {string} [data.projectId] projectId
 */
function SendLog(data) {
    let { type = 'click', dpm, dcm, dom, appID, projectId } = data;
    const CFG = window.CFG;
    appID = appID || (CFG ? CFG.appID : '');
    projectId = projectId || (CFG ? CFG.projectId : '');
    if (!appID || !projectId || !dpm) {
        console.warn('未设置appID或projectId或dpm !!!');
        return;
    }
    dpm = `${appID}.110.${dpm}`;
    dcm = dcm || `202.${projectId}.0.0`;
    let params = {
        dpm,
        dcm,
        appId: appID,
    };
    if(dom) params.dom = dom;
    if (type === 'click') {
        jsonp('/log/click', params);
    } else {
        jsonp('//embedlog.duiba.com.cn/exposure/standard', params);
    }
    // console.log('sendLog', params);
}
/**
 * 发送jsonp请求
 * @param {string} url 请求地址
 * @param {{}} params 请求参数
 */
function jsonp(url, params = {}) {
    const src = url + '?' + getParams(params);
    const scriptEl = document.createElement('script');
    scriptEl.src = src;
    scriptEl.onload = function () {
        document.body.removeChild(scriptEl);
    };
    scriptEl.onerror = function () {
        document.body.removeChild(scriptEl);
    };
    document.body.appendChild(scriptEl);
}
/**
 * 对象格式转get请求参数格式，并且加上时间戳
 * @param {{}} data
 */
function getParams(data = {}) {
    const arr = [];
    for (let key in data) {
        arr.push(encodeURIComponent(key) + '=' + encodeURIComponent(data[key]));
    }
    //加时间戳防止浏览器取缓存的接口数据
    arr.push('_=' + Date.now());
    return arr.join('&');
}

