/*
将此文件放到project/config/scripts/assets/目录下
在package.json文件的"scripts"字段下，分别修改dev和build命令：
"dev": "node ./config/scripts/assets/generateAssetList.js && node ./config/webpack.dev.config.js"
"build": "node ./config/scripts/assets/generateAssetList.js && node ./config/scripts/assets/index.js imgmin imgup && node ./config/webpack.prod.config.js"
*/

const fs = require('fs');

/** 预加载资源文件夹正则，用于匹配./src/assets目录下的文件夹 */
const preloadFolderRegExp = /\/(test)\//; // 要匹配所有的资源，写/\/(.+)\//
/** 合法资源正则 */
const assetRegExp = /\.(png|jpg|jpeg|svga|spi|json|mp3|wav)$/i;
// 读资源目录
const [preloadAsset, otherAsset] = searchFileFromFolder('./src/assets', [
    { 
        folderRegExp: preloadFolderRegExp, 
        fileRegExp: assetRegExp
    }
]);
// console.log('assetList', preloadAsset, otherAsset);

// 写资源列表json
fs.writeFileSync(
    './src/assetList.json', 
    JSON.stringify({
        preloadAsset: preloadAsset.map(v => v.replace("./src/assets/", '')), 
        otherAsset: otherAsset.filter(v => assetRegExp.test(v)).map(v => v.replace("./src/assets/", '')),
    })
);

/**
 * 搜索文件夹里的文件
 * @param {string} folderPath 文件夹地址，相对路径
 * @param {object[]} ruleList 规则列表，例[{folderRegExp: /\/(index|game)\//, fileRegExp: /.(png|jpg)$/}]
 * @returns {string[]} 返回文件相对路径地址
 */
function searchFileFromFolder(folderPath, ruleList) {
    if (!fs.existsSync(folderPath)) {
        console.warn('searchFileFromFolder', folderPath, '路径不存在');
        return;
    }
    if (!fs.statSync(folderPath).isDirectory()) {
        console.warn('searchFileFromFolder', folderPath, '不是文件夹');
        return;
    }
    /** 最后输出的资源路径列表 */
    const pathList = [];
    for (let index = 0; index < ruleList.length + 1; index++) pathList.push([]);
    /** 递归查找方法 */
    const searchOneDir = (folderPath) => {
        fs.readdirSync(folderPath).forEach(content => {
            const secondaryPath = folderPath + '/' + content;
            if(fs.statSync(secondaryPath).isFile()) {
                // 文件匹配
                let isMatched = false;
                ruleList.forEach((v, i) => {
                    // 目录及文件匹配
                    if (v.folderRegExp.test(secondaryPath) && v.fileRegExp.test(secondaryPath)) {
                        pathList[i].push(secondaryPath);
                        isMatched = true;
                    }
                })
                !isMatched && pathList[pathList.length - 1].push(secondaryPath);
            }else {
                searchOneDir(secondaryPath);
            }
        });
    }
    searchOneDir(folderPath);
    // console.warn('pathList', pathList);
    return pathList;
}

