export { GetAndroidVersion, GetIosVersion, isWx, isWxMini }

/**
 * 获取安卓版本号
 * @param {string} [ua] 
 */
function GetAndroidVersion(ua) {
    ua = (ua || navigator.userAgent).toLowerCase();
    var match = ua.match(/android\s([0-9\.]*)/);
    return match ? match[1] : false;
}

/**
 * 获取ios版本号
 * @param {string} [ua] 
 */
function GetIosVersion(ua) {
    ua = (ua || navigator.userAgent).toLowerCase();
    var match = ua.match(/cpu iphone os (.*?) like mac os/);
    return match ? match[1] : false;
}

/**
 * 判断是否是微信环境
 */
function isWx() {
    return !!navigator.userAgent.match(/MicroMessenger/i)
}

/**
 * 判断是否是微信小程序环境
 * @example 
 * // 引入：
 * <script type="text/javascript" src="//res.wx.qq.com/open/js/jweixin-1.6.0.js"></script>
 * // 判断：
 * let result = await isWxMini()
 */
function isWxMini() {
    return new Promise((resolve)=>{
        wx.miniProgram.getEnv((res) => {
            res.miniprogram ? resolve(true) : resolve(false)
        })
    })
}