export { TimerController }
/** 
 * 定时器类
 */
class TimerController {
    /** 存储标记的定时id */
    signedIdMap = {}

    /** 未标记的定时id列表 */
    unsignedIdList = []

    /**
     * 定时执行一个方法
     * @param {Function} fn 定时调用的方法
     * @param {number} [time] 定时时间
     * @param {string} [sign] 定时标记，执行时会先清除之前的同标记定时——意思是如果传入标记那么该定时只会同时存在一个
     * @returns {number} timer id
     */
    start = (fn, time, sign)=>{
        sign && clearTimeout(sign);
        let id = setTimeout(fn, time);
        sign ? this.signedIdMap[sign] = id : this.unsignedIdList.push(id);
        return id
    }

    /**
     * 按标记清除定时，有则清除，没有也无副作用
     * @param {string} sign 定时标记
     */
    clear = (sign)=>{
        this.signedIdMap[sign] && clearTimeout(this.signedIdMap[sign]);
    }

    /**
     * 清除所有定时
     */
    clearAll = ()=>{
        Object.keys(this.signedIdMap).forEach(v => clearTimeout(this.signedIdMap[v]));
        this.unsignedIdList.forEach(v => clearTimeout(v));
    }
}