import apiCfg from './apicfg';
import { getPxToken } from "@spark/projectx";
import { callApi } from '@spark/api-base'
import { isFromShare, newUser } from 'duiba-utils';
import { Loading } from '@spark/ui'
import { Global } from '../global.js'

let mergeData = {
	user_type: newUser ? '0' : '1',
	is_from_share: isFromShare ? '0' : '1',
}

const apiList = {
	...apiCfg
}


const API = generateAPI(apiList);
export default API;

function getRequestParams(value) {
	if (typeof value === 'string') {
		return {
			uri: value,
			method: 'get'
		}
	} else if (typeof value === 'object') {
		const { uri, method = 'get', headers, withToken, secret, secretKey, contentType = 'form', showLoading = false, showMsg = true } = value;
		return {
			uri,
			method,
			headers,
			withToken,//是否传入token
			secret,
			secretKey,
			contentType,
			showLoading,// 是否展示loading
			showMsg,// 是否自动处理success:false并抛出msg
		}
	} else {
		console.error('getRequestParams: 传参有误');
	}
}


export function generateAPI(apiList) {
	const api = {};
	let isTokenRequestResponded = true;//用于标记带token的接口是否响应完毕
	for (let key in apiList) {
		let value = apiList[key];

		let { method, uri, headers: mHeaders, withToken, secret, secretKey, contentType, showLoading, showMsg } = getRequestParams(value);
		api[key] = async (params = {}, headers) => {
			showLoading && Loading.show();// 根据接口配置showLoading展示loading
			let token;
			if (withToken) {
				if (isTokenRequestResponded) {//上一个带token的接口响应完毕，则把新的带token的接口请求标记为尚未响应
					isTokenRequestResponded = false;
				} else {//上一个带token的接口尚未响应完毕，则停止新的带token的接口的请求
					console.warn('上一个带token的接口尚未响应完毕，已停止新的带token的接口的请求，原因可能是：1.接口防连点未做好 2.弱网环境（延迟比防连点时长还高）的连续请求')
					return
				}
				try {
					token = await getPxToken();
				} catch (e) {
					isTokenRequestResponded = true;// 网络异常时置为true，保证网络恢复时能正常请求带token的接口
					Global.Itoast('网络异常!')
					showLoading && Loading.hide();// 根据接口配置showLoading关闭loading
					return;
				}
			}
			let mergedHeaders = { ...mHeaders, ...headers }
			if (withToken && token) {
				params.token = token;
			}
			params = { ...params, ...mergeData };

			const result = await callApi(uri, params, method, mergedHeaders, false, secret, secretKey, contentType)
				.catch(e => {
					// 捕获网络异常
					Global.Itoast('网络异常~')
				});
			showLoading && Loading.hide();// 根据接口配置showLoading关闭loading
			if (withToken && token) {//带token的接口响应完毕
				isTokenRequestResponded = true;
			}
			if (result) {// 网络正常，拿到了响应数据
				if (result.success) {// success:true
					return result; // return响应结果，用then拿数据
				} else {// success:false
					// 判断接口配置showMsg
					if (showMsg) {// 自动处理，toast出后端msg，不用写catch也不会触发catch
						Global.Itoast(result.message || '网络异常');
					} else {// 手动处理，throw响应结果，用catch拿数据
						throw result;
					}
				}
			}
		}
	}

	return api;
}
