import MD from 'spark-utils/out/md/index.js';

let appId = CFG.appID;
const dcm = '202.' + CFG.projectId + '.0.0';
// const dom = CFG.channel + '.0.0.0'
const domain = '//embedlog.duiba.com.cn';

// 总埋点数据，包含所有埋点号
let rawList = [];
for (let index = 1; index <= 80; index++) {
  rawList.push({
    ele: `.md${index}`,
    data: {
      dpm: `${appId}.110.${index}.1`,
      dcm,
      // dom,
      domain,
      appId,
    },
    once: false,
    index: index
  });
}
// 不需要自动曝光埋点的索引
const noShowIndexs = [];
// 不需要自动点击埋点的索引
const noClickIndexs = []
// 曝光埋点列表
const showList = rawList.filter(v1 => !noShowIndexs.some(v2 => v2 == v1.index))
// 点击埋点列表
const clickList = rawList.filter(v1 => !noClickIndexs.some(v2 => v2 == v1.index))
// console.log('showList',showList);
// console.log('clickList',clickList);

export default () =>
  MD({
    show: showList, // 曝光
    click: clickList // 点击
  });

