import React, { Component } from "react";

import "./LunboRealData.less";

export default function LunboCtrl(carouselData) {

    return class LunboCom extends Component {
        constructor(props) {
            super(props);
            this.state = {
                top1: 0,
                top2: 0,
            };
            this.itemHeight = 0; //列表项的真实高度取整后的值
            this.step = 1; //步长
            this.totalStep = 0; //记录每一次列表项消失走的步数
            this.itemHeightDot = 0.0; //列表项的真实高度
            this.totalHeight = 0; //一个列表的高度
        }
        loop() {
            let timer = setTimeout(() => {
                clearTimeout(timer);
                let top1 = this.state.top1;
                let top2 = this.state.top2;

                if (top1 + this.totalHeight === 0) {
                    top1 = this.totalHeight;
                }
                if (top2 + this.totalHeight === 0) {
                    top2 = this.totalHeight;
                }
                this.setState({
                    top1: top1 - this.step,
                    top2: top2 - this.step,
                });
                this.totalStep = this.totalStep + 1;

                if (this.totalStep === this.itemHeight) {
                    this.totalStep = -1;
                    this.step = this.itemHeightDot - this.itemHeight;
                    setTimeout(() => {
                        this.loop();
                    }, 1000);
                } else {
                    this.step = 1;
                    this.loop();
                }
            }, 40);
        }
        componentDidMount() {
            let el = document.getElementById("articleShuffling");
            let lenstr = window.getComputedStyle(el).webkitLogicalHeight;

            this.itemHeightDot = Number(lenstr.slice(0, lenstr.length - 2));
            this.itemHeight = parseInt(this.itemHeightDot);

            this.totalHeight = this.itemHeightDot * carouselData.length;
            this.setState({
                top1: 0,
                top2: this.totalHeight,
            });

            setTimeout(() => {
                this.loop();
            }, 1000);
        }
        render() {
            return (
                <div id="articleShuffling" className="articleShuffling">
                    <div className="rollup ">
                        <div
                            style={{
                                boxSizing: "border-box",
                                position: "absolute",
                                top: this.state.top1 + "px",
                            }}
                        >
                            {carouselData.map((item, index) => {
                                return (
                                    <span
                                        key={index}
                                        className="user1885678ObtainedXxx"
                                    >
                                        {item.text}
                                    </span>
                                );
                            })}
                        </div>
                        <div
                            style={{
                                boxSizing: "border-box",
                                position: "absolute",
                                top: this.state.top2 + "px",
                            }}
                        >
                            {carouselData.map((item, index) => {
                                return (
                                    <span
                                        key={index}
                                        className="user1885678ObtainedXxx"
                                    >
                                        {item.text}
                                    </span>
                                );
                            })}
                        </div>
                    </div>
                </div>
            );
        }
    };
}
