//@ts-ignore
export class Dazhuanpan extends FYGE.Container{
    dzpBg:FYGE.Sprite;
    rotatePart:FYGE.Sprite;
    pointer:FYGE.Sprite;
    beginBtn:FYGE.Sprite;
    prizeList:any;
    roatteTween:any;
    prizeId:any;
    callback:any;
    prizePosition:Array<number>;
    constructor(bgImg,innerImg,beginBtnImg,pointImg,prizePosition,prizeList,callback?){
        super();
        this.dzpBg = FYGE.Sprite.fromUrl(bgImg);
        this.addChild(this.dzpBg);

        this.rotatePart = FYGE.Sprite.fromUrl(innerImg);
        this.dzpBg.addChild(this.rotatePart);

        this.pointer = FYGE.Sprite.fromUrl(pointImg);
        this.dzpBg.addChild(this.pointer);

        this.beginBtn = FYGE.Sprite.fromUrl(beginBtnImg);
        this.dzpBg.addChild(this.beginBtn);

        this.prizePosition = prizePosition;
        this.prizeList = prizeList;
        this.addPrizeOnDzp(prizeList);

        this.callback = callback;
        this.beginBtn.addEventListener(FYGE.MouseEvent.CLICK,()=>{
           this.beginRotateDzp() 
        },this)

    }
    setRotatePartPosition(x,y){
        this.rotatePart.position.set(x,y);
    }
    setPointerPosition(x,y){
        this.pointer.position.set(x,y);
    }
    setBeginBtnPosition(x,y){
        this.beginBtn.position.set(x,y);
    }
    setHitPrize(prizeId){
        this.prizeId = prizeId;
    }
    addPrizeOnDzp(prizeList){
        let len = prizeList.length;
        let deg = 360/len;
        prizeList.forEach((el, index) => {
            let prize = FYGE.Sprite.fromUrl(el.icon);
            prize.width = 84;
            prize.height = 53;
            let prizeContainer = new FYGE.Container();
            prizeContainer.addChild(prize);
            prizeContainer.position.set(this.prizePosition[0],this.prizePosition[1]);
            prizeContainer.anchorX = 41;
            prizeContainer.anchorY = 145;

            let prizeName = new FYGE.TextField();
            prizeName.textWidth = 150;
            prizeName.textAlign = FYGE.TEXT_ALIGN.CENTER;
            prizeName.text = el.name;
            prizeName.size = 22;
            prizeName.fillColor = "#ffffff";
            prizeName.stroke = 2;
            prizeName.strokeColor = "#eb9e51";
            prizeName.position.set(this.prizePosition[0]-35, this.prizePosition[1]-35);
            prizeName.anchorX = 75;
            prizeName.anchorY = 181;

            prizeContainer.rotation = 360 - index * deg;
            prizeName.rotation = 360- index * deg
         
            this.rotatePart.addChild(prizeContainer);
            this.rotatePart.addChild(prizeName)
        })
    }
    resetDzp(){
        this.rotatePart.rotation = 0;
    }
    beginRotateDzp(){
        var index = null;
        this.prizeList.forEach((el, i) => {
            if (el.prizeId === this.prizeId) {
                index = i;
            }
        });
        console.log(index)

        if (index === null) {
            console.log("抽奖异常");
            return;
        }
        let len = this.prizeList.length;
        let deg = 360/len;
        let rotateDeg = index * deg;
        this.beginBtn.mouseEnable = false;
        this.beginBtn.mouseChildren = false;
        this.rotatePart.rotation = 0;
        this.rotatePart.anchorX = 226;
        this.rotatePart.anchorY = 227;
        this.roatteTween = FYGE.Tween.get(this.rotatePart)
            .to({ rotation: 180 }, 200)
            .to({ rotation: 360 }, 300)
            .to({ rotation: 540 }, 400)
            .to({ rotation: 720 }, 500)
            .to({ rotation: 900 }, 900)
            .to({ rotation: 1080 }, 2000)
            .to({ rotation: 1080+rotateDeg}, 4000 * rotateDeg / 180)
            .call(() => {
                this.beginBtn.mouseEnable = true;
                this.beginBtn.mouseChildren = true;
                this.callback && this.callback();
            })
    }
}