export class CarouselComponent extends FYGE.Container {
    bgContainer: FYGE.Container;
    itemComponent: any;
    itemWidth: number;
    itemHeight: number;
    vertical: boolean;
    timer: any;
    listContainer1: any;
    listContainer2: any;
    listWidth: number;
    listHeight: number;
    bgmask: FYGE.Graphics;
    num: number;
    k: number;//缓动系数，系数越大移动越快。在0-1之间。
    totalStep: number;//累计移动了多少距离
    stopStep: number;//滑动多少距离之后暂停一下
    /**
     * 
     * @param itemComponent //item组件
     * @param itemWidth //每一个item的宽度
     * @param itemHeight //每一个item的高度
     * @param vertical //是否是垂直的
     * @param num //要显示的个数
     * @param k ////缓动系数，系数越大移动越快。在0-1之间
     */
    constructor(itemComponent, itemWidth, itemHeight, vertical = false, num = 3, k = 0.24) {
        super();
        this.num = num;
        this.totalStep = 0;
        this.bgContainer = new FYGE.Container();
        this.itemComponent = itemComponent;
        this.itemHeight = itemHeight;
        this.itemWidth = itemWidth;
        this.vertical = vertical;
        this.k = k;
        if (this.vertical) {
            this.stopStep = itemHeight;
            this.bgmask = new FYGE.Graphics();
            this.bgmask.beginFill();
            this.bgmask.drawRect(0, 0, itemWidth, num * itemHeight)
            this.bgmask.endFill();
        } else {
            this.stopStep = itemWidth;
            this.bgmask = new FYGE.Graphics();
            this.bgmask.beginFill();
            this.bgmask.drawRect(0, 0, num * itemWidth, itemHeight)
            this.bgmask.endFill();
        }
    }
    //更新数据触发轮播
    updateData(data) {
        this.removeChildren();
        this.bgContainer.removeChildren();
        this.timer && clearTimeout(this.timer);
        this.timer = null;
        this.addChild(this.bgmask);
        this.listContainer1 = new FYGE.Container();
        this.listContainer2 = new FYGE.Container();
        data.forEach((el, index) => {
            let picture1 = new this.itemComponent(el);
            let picture2 = new this.itemComponent(el);
            if (!this.vertical) {
                picture1.position.set(index * this.itemWidth, 0);
                picture2.position.set(index * this.itemWidth, 0);
            } else {
                picture1.position.set(0, index * this.itemHeight);
                picture2.position.set(0, index * this.itemHeight);
            }
            this.listContainer1.addChild(picture1);
            this.listContainer2.addChild(picture2);
        })
        if (!this.vertical) {
            this.listWidth = data.length * this.itemWidth;
            this.listContainer1.position.set(0, 0)
            this.listContainer2.position.set(data.length * this.itemWidth, 0)
        } else {
            this.listHeight = data.length * this.itemHeight;
            this.listContainer1.position.set(0, 0)
            this.listContainer2.position.set(0, data.length * this.itemHeight)
        }
        this.bgContainer.addChild(this.listContainer1);
        this.bgContainer.addChild(this.listContainer2);
        this.addChild(this.bgContainer);
        this.bgContainer.mask = this.bgmask;
        setTimeout(() => {
            this.loop();
        }, 1000)
    }
    loop() {
        this.timer && clearTimeout(this.timer);
        this.timer = null;
        var step = (this.stopStep - this.totalStep) * this.k;
        step = parseInt(step.toFixed(0))
        step = step ? step : 1;
        var sum = this.totalStep + step;
        if (sum > this.stopStep) {
            step = this.stopStep - this.totalStep;
        }
        // console.log(step)
        if (!this.vertical) {
            let x1 = this.listContainer1.x
            let x2 = this.listContainer2.x

            if (x1 + this.listWidth < 0) {
                x1 = this.listWidth + (x1 + this.listWidth);
            }
            if (x2 + this.listWidth < 0) {
                x2 = this.listWidth + (x2 + this.listWidth);
            }
            this.listContainer1.position.set(x1 - step, 0)
            this.listContainer2.position.set(x2 - step, 0)
        } else {
            let y1 = this.listContainer1.y
            let y2 = this.listContainer2.y
            if (y1 + this.listHeight < 0) {
                y1 = this.listHeight + (y1 + this.listHeight);
            }
            if (y2 + this.listHeight < 0) {
                y2 = this.listHeight + (y2 + this.listHeight);
            }
            this.listContainer1.position.set(0, y1 - step)
            this.listContainer2.position.set(0, y2 - step)
        }
        this.totalStep = this.totalStep + step
        if (Math.abs(this.stopStep - this.totalStep) < 0.1) {
            this.setTimeoutSelf(() => {
                this.timer = this.setTimeoutSelf(() => {
                    this.loop()
                }, 50)
            }, 1000)
            this.totalStep = 0;
        } else {
            this.timer = this.setTimeoutSelf(() => {
                this.loop()
            }, 50)
        }
    }
    setTimeoutSelf(cb, interval) { // 实现setTimeout功能
        let now = Date.now
        let stime = now()
        let etime = stime
        let loop = () => {
            var timeoutTimer = requestAnimationFrame(loop)
            etime = now()
            if (etime - stime >= interval) {
                cb()
                cancelAnimationFrame(timeoutTimer)
            }
        }
        loop()
    }
    destroy() {
        this.timer && clearTimeout(this.timer);
        this.timer = null;
    }
}