import React from "react";

import { UnControlled as CodeMirror } from "react-codemirror2";
const jsBeautify = require("js-beautify").html;

interface Props {
    code: string;
}

const CodePanel = (args: Props) => {
    return (
        <div className="code">
            <CodeMirror
                value={args.code}
                options={{
                    mode: "javascript",
                    theme: "dracula",
                    lineNumbers: true,
                    lineWrapping: false,
                    indentWithTabs: true,
                    smartIndent: true,
                }}
            />
        </div>
    );
};
const StylePanel = (args: Props) => {
    return (
        <div className="code">
            <CodeMirror
                value={args.code}
                options={{
                    mode: "css",
                    theme: "dracula",
                    lineNumbers: true,
                    lineWrapping: false,
                    indentWithTabs: true,
                    smartIndent: true,
                }}
            />
        </div>
    );
};
export const CodeCom = () => {
    let useCode = getUseCodeStr();
    let sourceCode = getSourceCode();
    let itemCodeStr = getItemCodeStr();
    let itemStyleStr = getItemStyleStr();
    let comStyleStr = getComStyleStr();
    return (
        <div className="codeContainer">
            <label className="title">组件使用代码：</label>
            <CodePanel code={useCode} />

            <label className="title">danmaItem源码：</label>
            <CodePanel code={itemCodeStr} />
            <label className="title">danmaItem样式：</label>
            <StylePanel code={itemStyleStr} />

            <label className="title">组件Danma源码代码：</label>
            <CodePanel code={sourceCode} />

            <label className="title">组件Danma样式：</label>
            <StylePanel code={comStyleStr} />
        </div>
    );
};

const getItemCodeStr = () => {
    return `
'use strict';

import React, { Component } from 'react';

import './danmaItem.less';

class DanmaItem extends Component {
    constructor(props) {
        super(props);
    }

    render() {
        const { danmaText, danmaAvatar, style } = this.props
        return (
            <div className="dan_mu_2 " style={style}>
                <div className="gun_dong_xin_xi ">
                    <img className="yuan_jiao_ju_xing_2389 " src={"//yun.duiba.com.cn/spark/assets/c471a10228088d7db7ac6ecc4cbf513cf5f4ac92.png"} />
                    <span className="danmaText ">{danmaText}</span>
                </div>
                <div className="hao_you_tou_xiang ">
                    <img className="tuo_yuan_2076_kao_bei " src={"//yun.duiba.com.cn/spark/assets/dae05e04aaa462ff72dd9c143823e1df68c08e65.png"} />
                    <img
                        className="danmaAvatar "
                        src={danmaAvatar}
                    />
                </div>
            </div>
        );
    }
}

export default DanmaItem;

        `;
};
const getItemStyleStr = () => {
    return `
.dan_mu_2 {
    width: 387px;
    height: 69px;
    position: absolute;

    .gun_dong_xin_xi {
        width: 364px;
        height: 58px;
        left: 23px;
        top: 6px;
        position: absolute;

        .yuan_jiao_ju_xing_2389 {
            width: 364px;
            height: 58px;
            left: 0px;
            top: 0px;
            opacity: 0.4;
            position: absolute;
        }

        .danmaText {
            width: 380px;
            height: 26px;
            left: 57px;
            top: 14px;
            position: absolute;
            font-size: 20px;
            color: red;
        }
    }

    .hao_you_tou_xiang {
        width: 69px;
        height: 69px;
        left: 0px;
        top: 0px;
        position: absolute;

        .tuo_yuan_2076_kao_bei {
            width: 69px;
            height: 69px;
            left: 0px;
            top: 0px;
            position: absolute;
        }

        .danmaAvatar {
            width: 65px;
            height: 65px;
            border-radius: 100px;
            left: 2px;
            top: 2px;
            position: absolute;
        }
    }
}
    `;
};

const getComStyleStr = () => {
    return `
.codeText {
    width: 750px;
    height: 1624px;
    position: absolute;
    display: inline-block;
}

.view {
    width: 750px;
    height: 1624px;
    left: 780px;
    background-color: aqua;
    position: absolute;
    display: inline-block;
}
    `;
};
//使用代码
const getUseCodeStr = () => {
    return `
export const Danma = (data) => {
    const Danma = DanmaCtrl(data.DanmaItem, data.danmaData, data.speed, data.width, data.height)
    return (
        <>
        <Danma />
        </>
    )
}
    `;
};
//源码
const getSourceCode = () => {
    return `
import React from "react";

/**
 * 
 * @param {*} DanmaItem 传入的弹幕Item Item
 * @param {*} DanmaData 弹幕数据 [{},{}]
 * @param {Array} speed 移动速度 [2,3,1,3]
 * @param {*} DanmaItemWidth 弹幕Item宽度 200
 * @param {*} DanmaItemHeight 弹幕Item高度/2 30
 * @returns 不知道写了啥
 */
export default function DanmaCtrl(DanmaItem, DanmaData, speed, DanmaItemWidth, DanmaItemHeight) {
    return class extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
        danmaItems: new Map()
        }
        this.pos = 350
        this.top = DanmaItemHeight + 15
        this.col = speed.length
        /**  speed*(fixedTime-spaceTime)>DanmaItem.width  不重叠 */
        this.speed = speed
        this.fixedTime = 50
        this.spaceTime = 50
        this.i = 0
        this.sendTaskMap = new Map()
        this.totalMinusTime = 0
        this.nowDanmaItems = new Map()
        this.requestAnimationFrameId = null
    }

    componentDidMount() {
        for (let i = 0; i < this.col * 2; i++) {
        let t = (this.fixedTime + DanmaItemWidth / this.speed[i % this.col]) * Math.floor(i / this.col) + this.spaceTime * Math.random()
        let data = {
            danmaData: this.getDanmaData(),
            t: t
        }
        this.sendTaskMap.set(i, data)
        }
        this.danmaMove()
    }


    getDanmaData() {
        const data = {
        danmaData: DanmaData[this.i % DanmaData.length],
        i: this.i
        }
        this.i++
        return data
    }


    sendDanma(data) {
        const newDanmaItem = React.createElement(DanmaItem, {
        key: data.i,
        ...data.danmaData,
        style: {
            left: this.pos + "px",
            top: this.top * (data.i % this.col) + "px"
        }
        })

        this.nowDanmaItems.set(data.i, newDanmaItem)
        this.setState({
        danmaItems: this.nowDanmaItems
        })
    }
    danmaMove = async () => {
        this.totalMinusTime++
        let danmaContainer = document.getElementById("danmaContainer")
        if (danmaContainer) {
        let danmaItems = danmaContainer.children
        for (let i = danmaItems.length - 1; i >= 0; i--) {
            let danmaItem = danmaItems[i]
            danmaItem.style.left = danmaItem.offsetLeft - this.speed[Math.floor(danmaItem.offsetTop / this.top)] + 'px'
            if (danmaItem.offsetLeft + danmaItem.offsetWidth < -100) {

            let l = Math.floor(danmaItem.offsetTop / this.top)
            let nowDanmaItems = this.state.danmaItems
            for (let j = 0; j < this.i; j++) {
                if (j % this.col == l) {
                let v = nowDanmaItems.get(j)
                if (v) {
                    if (v == "remove") {
                    break
                    }
                    nowDanmaItems.set(j, 'remove')
                    break
                }
                }
            }
            this.nowDanmaItems = nowDanmaItems

            let t = (this.fixedTime + DanmaItemWidth / this.speed[this.i % this.col]) * Math.floor(this.i / this.col) + this.spaceTime * Math.random() - this.totalMinusTime
            let danmaData = this.getDanmaData()
            let data = {
                danmaData: danmaData,
                t: t
            }
            this.sendTaskMap.set(this.i, data)
            }
        }
        }
        this.sendTaskMap.forEach((data, i) => {
        let t = data.t--

        if (t <= 0) {
            this.sendDanma(data.danmaData)
            this.sendTaskMap.delete(i)
        }
        })
        this.requestAnimationFrameId = requestAnimationFrame(this.danmaMove)
    }


    map2arr = (map) => {
        let arr = []
        map.forEach((item, index) => {
        if (item != 'remove') {
            arr.push(item)
        } else {
            map.delete(index)
        }
        })
        return arr
    }


    componentWillUnmount() {
        this.requestAnimationFrameId && cancelAnimationFrame(this.requestAnimationFrameId)
    }

    render() {
        let {
        danmaItems
        } = this.state
        return (
        <div id="danmaContainer" >
            {this.map2arr(danmaItems)}
        </div>
        )
    }
    };
}
    `;
};
