import React from "react";
import { Danma } from "../../sourceCode/react/danma/danma";
import DanmaItem from "../../sourceCode/react/danma/danmaItem";
import {
    Title,
    Subtitle,
    Description,
    ArgsTable,
    PRIMARY_STORY,
} from "@storybook/addon-docs";
import { CodeCom } from "./codeCom";
import { clearStage } from "../../common/createStage";

export default {
    component: Danma,
    title: "React组件/弹幕",
    parameters: {
        docs: {
            page: () => {
                clearStage();
                return (
                    <>
                        <Title />
                        <Subtitle />
                        <Description />
                        <ArgsTable story={PRIMARY_STORY} />
                        <CodeCom></CodeCom>
                    </>
                );
            },
        },
    },
};
let danmaAvatars = [
    "//yun.duiba.com.cn/polaris/1022.5d0247352e3f1a068cd812df9051079b111ef0a5.jpg",
    "//yun.duiba.com.cn/polaris/1022.5d0247352e3f1a068cd812df9051079b111ef0a5.jpg",
    "//yun.duiba.com.cn/polaris/1020.dc6994ddeb5726f99a5ab9692f1a339ecd46a99b.jpg",
    "//yun.duiba.com.cn/polaris/1009.3307be2f8053aad97259c34062934185a200eac4.jpg",
    "//yun.duiba.com.cn/polaris/226.24bc5cff2e5ce9786f3f91822073a8e07d8e72a2.jpg",
    "//yun.duiba.com.cn/polaris/167.86ddf7a8a38a1f3d65b1eaea8b366ea865455d5f.jpg",
    "//yun.duiba.com.cn/polaris/160.4e523285ae71ca3102ebf5abcec94c768a03dee3.jpg",
    "//yun.duiba.com.cn/polaris/152.ad66124d7a5bb408aab23dc4df6b3a48d5cc3e3d.jpg",
    "//yun.duiba.com.cn/polaris/151.c780044a45f4bb54886abc0c6ced752c646c9258.jpg",
    "//yun.duiba.com.cn/polaris/93.e03b23d831096c181f5a216e851890fe9720a529.jpg",
    "//yun.duiba.com.cn/polaris/74.583f9804214c592abbdb20d9bc22699016a14111.jpg",
    "//yun.duiba.com.cn/polaris/13.74093d5f56cfd4407cb1364a0b39420c1cf6cd49.jpg",
    "//yun.duiba.com.cn/polaris/21.20b8b067a25a8217cd4be2934e55a4fcaf090f11.jpg",
    "//yun.duiba.com.cn/polaris/32.886b712236952e68b52bb8c9ed489aa71e4696eb.jpg",
    "//yun.duiba.com.cn/polaris/35.556e40e6e2c1f47e0907b35faef3470990565778.jpg",
    "//yun.duiba.com.cn/polaris/46.acb5c7e7abd8b8f476bd3e495b253412e537578a.jpg",
    "//yun.duiba.com.cn/polaris/51.21cf0c7f2784616b92470559a2b259668bb35465.jpg",
    "//yun.duiba.com.cn/polaris/91.e7db79153cab5dfeb0ed05c5ac0efad7ed2c0f62.jpg",
    "//yun.duiba.com.cn/polaris/110.6f9d23a83f44b22bce4b580380c65e65e5e69d88.jpg",
    "//yun.duiba.com.cn/polaris/296.cbff50bfde5f4d61461f486f2a37ae8aa495eed9.jpg",
    "//yun.duiba.com.cn/polaris/248.d535ab0bb6ed1bad5f863c161ffe7e53adcf129c.jpg",
    "//yun.duiba.com.cn/polaris/389.81c5dc97d4f5f7c409a7463cc1d64c15395e9ccf.jpg",
    "//yun.duiba.com.cn/polaris/21.20b8b067a25a8217cd4be2934e55a4fcaf090f11.jpg",
    "//yun.duiba.com.cn/polaris/21.20b8b067a25a8217cd4be2934e55a4fcaf090f11.jpg",
];

let getPhoneNum = () => {
    let phoneHead = [181, 156, 131, 176, 138, 135];
    let head = phoneHead[Math.floor(Math.random() * phoneHead.length)];
    let bottomNum =
        "" +
        Math.floor(Math.random() * 10) +
        Math.floor(Math.random() * 10) +
        Math.floor(Math.random() * 10) +
        Math.floor(Math.random() * 10);

    return head + "****" + bottomNum;
};
let getPrize = () => {
    let prizes = [
        "100元立减金",
        "电影票X4",
        "爱国者耳机",
        "5元立减金",
        "100元立减金",
    ];
    return prizes[Math.floor(Math.random() * prizes.length)];
};

let danmaData = [
    {
        danmaText: getPhoneNum() + "获得" + getPrize(),
        danmaAvatar:
            danmaAvatars[Math.floor(Math.random() * danmaAvatars.length - 1)],
    },
    {
        danmaText: getPhoneNum() + "获得" + getPrize(),
        danmaAvatar:
            danmaAvatars[Math.floor(Math.random() * danmaAvatars.length - 1)],
    },
    {
        danmaText: getPhoneNum() + "获得" + getPrize(),
        danmaAvatar:
            danmaAvatars[Math.floor(Math.random() * danmaAvatars.length - 1)],
    },
    {
        danmaText: getPhoneNum() + "获得" + getPrize(),
        danmaAvatar:
            danmaAvatars[Math.floor(Math.random() * danmaAvatars.length - 1)],
    },
    {
        danmaText: getPhoneNum() + "获得" + getPrize(),
        danmaAvatar:
            danmaAvatars[Math.floor(Math.random() * danmaAvatars.length - 1)],
    },
    {
        danmaText: getPhoneNum() + "获得" + getPrize(),
        danmaAvatar:
            danmaAvatars[Math.floor(Math.random() * danmaAvatars.length - 1)],
    },
    {
        danmaText: getPhoneNum() + "获得" + getPrize(),
        danmaAvatar:
            danmaAvatars[Math.floor(Math.random() * danmaAvatars.length - 1)],
    },
    {
        danmaText: getPhoneNum() + "获得" + getPrize(),
        danmaAvatar:
            danmaAvatars[Math.floor(Math.random() * danmaAvatars.length - 1)],
    },
];

let speed = [1, 3, 2, 1, 4];
let width = 400;
let height = 60;

//@ts-ignore
// const Template = () => <Danma DanmaItem={DanmaItem} danmaData={danmaData} speed={speed} width={width} height={height} />;
const Template = (args) => <Danma {...args} />;
export const Primary = Template.bind({});

Primary.args = {
    primary: false,
    label: "Danma",
    DanmaItem: DanmaItem,
    danmaData: danmaData,
    speed: speed,
    width: width,
    height: height,
};
Primary.parameters = {
    layout: "centered",
};
