import React from "react";
import { Lunbo } from "../../sourceCode/react/LunboRealData/index";
import {
    Title,
    Subtitle,
    Description,
    ArgsTable,
    PRIMARY_STORY,
} from "@storybook/addon-docs";
import { CodeCom } from "./codeCom";
import { clearStage } from "../../common/createStage";
export default {
    component: Lunbo,
    title: "React组件/轮播(真实数据)",
    parameters: {
        docs: {
            page: () => {
                clearStage();
                return (
                    <>
                        <Title />
                        <Subtitle />
                        <Description />
                        <ArgsTable story={PRIMARY_STORY} />
                        <CodeCom></CodeCom>
                    </>
                );
            },
        },
    },
};
function getRondomNum(len) {
    len = len || 4;
    var $chars =
        "0123456789"; /****默认去掉了容易混淆的字符oOLl,9gq,Vv,Uu,I1****/
    var maxPos = $chars.length;
    var pwd = "";
    for (let i = 0; i < len; i++) {
        pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
    }
    return pwd;
}
function getCarouselData() {
    let data = [];
    for (let i = 0; i < 19; i++) {
        data.push({
            text: "尾号" + getRondomNum(4) + "获得了话费劵",
        });
    }
    data.push({
        text: "尾号" + getRondomNum(4) + "获得了戴森吹风机",
    });
    return data;
}
const carouselData = getCarouselData();

const Template = (args) => <Lunbo {...args} />;
export const Primary = Template.bind({});
Primary.args = {
    primary: false,
    label: "LunboRealData",
    carouselData: carouselData,
};
Primary.parameters = {
    layout: "centered",
};
