import React from 'react';
import {clearStage} from "../common/createStage"
import { useEffect } from 'react';
import {navigate,LinkTo, linkTo,hrefTo } from '@storybook/addon-links';
import "./totalCom.less"

import {canvasData,reactData} from "./data/comData"

const canvasClickFun = (name)=>{
    linkTo('Canvas组件/'+name)();
}
const reactClickFun = (name)=>{
    linkTo('React组件/'+name)();
}

export const TotalCom = ()=>{
    clearStage();
    return (
        <div className="total-container">
            <h2>canvas组件概览</h2>
            <div className ="container-div">
                {
                    canvasData.map((el,index)=>{
                        return (
                            <div key={index} className="itemCom" onClick = {canvasClickFun.bind(this,el.name)}>
                                <img src={el.imgUrl}  width = "200" height = "150"/>
                                <span className="com-link-span"  >{el.name}</span>
                            </div>
                        )
                    })
                }
            </div>
            <h2>React组件概览</h2>
            <div className ="container-div">
                {
                    reactData.map((el,index)=>{
                        return (
                            <div key={index}  className="itemCom" onClick = {reactClickFun.bind(this,el.name)}>
                                <img src={el.imgUrl}  width = "200" height = "150"/>
                                <span className="com-link-span"  >{el.name}</span>
                            </div>
                        )
                    })
                }
            </div>
        </div>
      
    )
}

