import React from 'react';
import {TotalCom} from "./totalCom";
import { clearStage } from '../common/createStage';
import {
  Title,
  Subtitle,
  Description,
  ArgsTable,
  PRIMARY_STORY,
} from '@storybook/addon-docs';


export default {
  component: TotalCom,
  title: '组件概览',
  parameters:{
    layout:"padded",
    docs: { 
      page: () => {
        clearStage();
        return <>
          <Title />
          <Subtitle />
          <Description />
          <ArgsTable story={PRIMARY_STORY} />
        </>
        },
    } 
  },
};
const Template = () => <TotalCom />;
export const componentsPreview = Template.bind({});
