export const createStage = () => {
    const height = document.body.clientHeight * (window.devicePixelRatio || 1) || 1624;
    const width = document.body.clientWidth * (window.devicePixelRatio || 1) || 750;
    const scale = window.devicePixelRatio;
    //@ts-ignore
    let canvas:HTMLCanvasElement = document.getElementById("canvas-container");
    if (!canvas) {
        canvas = document.createElement("canvas");
        canvas.setAttribute("id", "canvas-container")
        canvas.setAttribute("height", height + "");
        canvas.setAttribute("width", width + "");
        canvas.style.position = "absolute";
        canvas.style.top = 0 + "px";
        canvas.style.left = 0 + "px";
        document.body.appendChild(canvas);
    } else {
        return;
    }
    var stage = new FYGE.Stage(
        canvas,
        width,
        height,
        width,
        height,
        FYGE.RENDERER_TYPE.CANVAS,
        false,
        false
    )

    //点击事件绑定
    var mouseEvent = stage.onMouseEvent.bind(stage);

    canvas.addEventListener("touchstart", mouseEvent, false);
    canvas.addEventListener("touchmove", mouseEvent, false);
    canvas.addEventListener("touchend", mouseEvent, false);

    canvas.addEventListener("mousedown", mouseEvent, false);
    canvas.addEventListener("mousemove", mouseEvent, false);
    canvas.addEventListener("mouseup", mouseEvent, false);

    // canvas.addEventListener("click",mouseEvent,false);
    function loop() {
        stage.flush();
        FYGE.Tween.flush();
        requestAnimationFrame(loop);
    }

    loop();
    window.stage = stage;
}
export const isExistStage = (cb) => {
    if (window.stage) {
        cb && cb();
    } else {
        setTimeout(isExistStage, 100);
    }
}
export const clearStage = () => {
    let canvas = document.getElementById("canvas-container");
    if (canvas) document.body.removeChild(canvas);
}