import React from 'react';
import { RichTextCom } from './RichTextCom';
import { CodeCom } from './codeCom';
import {
  Title,
  Subtitle,
  Description,
  ArgsTable,
  PRIMARY_STORY,
} from '@storybook/addon-docs';
import { clearStage } from '../../common/createStage';
export default {
  component: RichTextCom,
  title: 'Canvas组件/丰富文本',
  //👇 Creates specific argTypes
  parameters: { 
    layout: 'centered',
    docs: { 
      page: () => {
        clearStage();
        return( <>
          <Title />
          <Subtitle />
          <Description />
          <ArgsTable story={PRIMARY_STORY} />
          <CodeCom></CodeCom>
        </>)
      },
    } 
  },
  
};

//👇 We create a “template” of how args map to rendering
const Template = (args) => <RichTextCom {...args} />;

//👇 Each story then reuses that template
export const Primary = Template.bind({});
Primary.args = {
  primary: true,
  label: '丰富文本',
  textArr: [
        { text: "啊请问请问", style: { color: "#00FF7F", size: 30 } },
        { text: "=2134324234啊请问请问", style: { color: "#ff0000", size: 30 } },
        { text: "驱蚊器问问", style: { color: "#9932CC", size: 30 } }
    ],
    x:400,
    y:100,
};


