import React from "react";
import { ProgressBarS } from "../../sourceCode/canvas/ProgressBarS";
import { createStage, isExistStage } from "../../common/createStage";

export const ProgressBarSCom = () => {
    createStage();
    window.stage.removeAllChildren();
    isExistStage(() => {
        //进度条底图
        //@ts-ignore
        var proBg = window.stage.addChild(
            FYGE.Sprite.fromUrl("resource/loadWhiteBar.png")
        );
        proBg.position.set(100, 200);

        //进度文字展示
        //@ts-ignore
        var progressBarLabel = new FYGE.TextField();
        progressBarLabel.text = "0";
        progressBarLabel.size = 24;
        progressBarLabel.fillColor = "#ef9222";
        progressBarLabel.stroke = 2;
        progressBarLabel.strokeColor = "#ffffff";
        progressBarLabel.position.set(450, 20);
        proBg.addChild(progressBarLabel);

        //进度条
        //@ts-ignore
        var pro = window.stage.addChild(
            FYGE.Sprite.fromUrl("resource/loadYellowBar.png")
        );
        pro.position.set(112, 208);

        //进度条托管
        var progressBar = new ProgressBarS(pro, null, (v) => {
            progressBarLabel.text = ((v * 100) >> 0) + "%";
        });

        //监听进度条前进信息
        //@ts-ignore
        window.stage.addEventListener(
            FYGE.Event.PROGRESS,
            (e) => {
                let pro = e.data;
                //@ts-ignore
                FYGE.Tween.get(progressBar).to({ value: pro }, 2000);
            },
            window.stage
        );

        //触发进度条前进
        //@ts-ignore
        window.stage.dispatchEvent(FYGE.Event.PROGRESS, 1);
    });
    return <div></div>;
};
