import React from "react";
import { ProgressBarSCom } from "./progressBarSCom";
import { CodeCom } from "./codeCom";
import {
    Title,
    Subtitle,
    Description,
    ArgsTable,
    PRIMARY_STORY,
} from "@storybook/addon-docs";
import { clearStage } from "../../common/createStage";

export default {
    component: ProgressBarSCom,
    title: "Canvas组件/进度条",
    //👇 Creates specific argTypes
    parameters: {
        layout: "centered",
        docs: {
            page: () => {
                clearStage();
                return (
                    <>
                        <Title />
                        <Subtitle />
                        <Description />
                        <ArgsTable story={PRIMARY_STORY} />
                        <CodeCom></CodeCom>
                    </>
                );
            },
        },
    },
};

//👇 We create a “template” of how args map to rendering
const Template = () => <ProgressBarSCom />;

//👇 Each story then reuses that template
export const Primary = Template.bind({});
