import React from 'react';
import { UnControlled as CodeMirror } from 'react-codemirror2';
const jsBeautify = require("js-beautify").html;

interface Props {
    code:string
}

const CodePanel =(args:Props) => {
    return(
        <div className = "code">
            <CodeMirror value={args.code}
            options = {{
                mode:"javascript",
                theme:"dracula",
                lineNumbers: true,
                lineWrapping: false,
                indentWithTabs: true,
                smartIndent: true,
            }}
            />
        </div>
    )
}
export const CodeCom = ()=>{
    let useCode = getUseCodeStr();
    let sourceCode = getSourceCode();
    return (
        <div className = "codeContainer">
            <label className="title">组件使用代码：</label>
            <CodePanel code ={useCode}/>
            <label className="title">组件源码代码：</label>
            <CodePanel code ={sourceCode}/>
        </div>
    )
}
//使用代码
const getUseCodeStr = ()=>{
    return `
//进度条底图
//@ts-ignore
var proBg = window.stage.addChild(FYGE.Sprite.fromUrl("resource/loadWhiteBar.png"))
proBg.position.set(100, 200);

//进度文字展示
//@ts-ignore
var progressBarLabel = new FYGE.TextField();
progressBarLabel.text = "0";
progressBarLabel.size = 24;
progressBarLabel.fillColor = "#ef9222"
progressBarLabel.stroke = 2;
progressBarLabel.strokeColor = "#ffffff"
progressBarLabel.position.set( 450,20);
proBg.addChild(progressBarLabel)

//进度条
//@ts-ignore
var pro = window.stage.addChild(FYGE.Sprite.fromUrl("resource/loadYellowBar.png"));
pro.position.set(112, 208)

//进度条托管
var progressBar = new ProgressBarS(pro ,null,(v)=>{
    progressBarLabel.text = ((v * 100) >> 0)+"%"
});

//监听进度条前进信息
//@ts-ignore
window.stage.addEventListener(FYGE.Event.PROGRESS, (e)=>{
    let pro = e.data;
    //@ts-ignore
    FYGE.Tween.get(progressBar)
    .to({ value: pro }, 2000)
}, window.stage);

//触发进度条前进
//@ts-ignore
window.stage.dispatchEvent(FYGE.Event.PROGRESS, 1);
    `
}
//源码
const getSourceCode = ()=>{
    return`
    import { initWxConfig } from "../../module/tools/wxShare";

    /**
     * 传入文案和进度条图片
     * 进度条图片位移，固定遮罩
     * 貌似这样就不需要继承显示类了
     */
    export class ProgressBarS {
        /**
         * 0到1的进度
         */
        private _value = 0;
        private upImage: FYGE.Sprite;
        private progressTxt: FYGE.TextField;
        private maxLength: number;
        private oriX: number;
        private callback:any;
        constructor(upImage: FYGE.Sprite, txt?: FYGE.TextField, callback?:(v) => void) {
            this.maxLength = upImage.width;//最大长度，直接取图片宽度
    
            this.upImage = upImage;
    
            this.progressTxt = txt;
    
            this.callback = callback;
            this.oriX = upImage.x;
            var delta = 0
            //传入的也可能是帧动画，这样原点就有问题了
            if (upImage instanceof FYGE.FrameAni) delta = 0.5
            //给图片加个矩形遮罩
            this.upImage.mask = this.upImage.parent.addChild(new FYGE.Graphics())
                .beginFill(0xf8c862)
                .drawRoundedRect(
                    upImage.x - upImage.width * delta,
                    upImage.y - upImage.height * delta,
                    upImage.width,
                    upImage.height,
                    111
                )
                .endFill();
    
    
            this.value = 0;
        }
    
        get value() {
            return this._value;
        }
        set value(v) {
            if (v < 0) v = 0;
            if (v > 1) v = 1;
            console.log("sssss")
            this._value = v;
            if (this.progressTxt) this.progressTxt.text = ((v * 100) >> 0) + "%";
            this.upImage.x = this.oriX - (1 - this._value) * this.maxLength;
            this.callback?this.callback(v):null
        }
    }    
    `
}