import React from 'react';
import { PolygonSystemCom } from './PolygonSystemCom';
import {CodeCom} from "./codeCom"
import {
  Title,
  Subtitle,
  Description,
  ArgsTable,
  PRIMARY_STORY,
} from '@storybook/addon-docs';
import { clearStage } from '../../common/createStage';

export default {
  component: PolygonSystemCom,
  title: 'Canvas组件/多边形坐标系统',
  //👇 Creates specific argTypes
  parameters: { 
    layout: 'centered',
    docs: { 
      page: () => {
        clearStage();
        return( <>
          <Title />
          <Subtitle />
          <Description />
          <ArgsTable story={PRIMARY_STORY} />
          <CodeCom></CodeCom>
        </>)
        },
    } 
  },
};

//👇 We create a “template” of how args map to rendering
const Template = (args) => <PolygonSystemCom {...args} />;

//👇 Each story then reuses that template
export const Primary = Template.bind({});
Primary.args = {
  primary: true,
  label: '多变形坐标系统',
  centerX:400, //坐标系统原点在弹窗中的x坐标
  centerY:200, //坐标系统原点在弹窗中的y坐标
  axiosNum:6, //3个坐标轴
  axiosNodeNum:3, //3个坐标节点
  unitLength:70, //坐标系统的单位长度,一个刻度多长。
  rotateDeg:90,
  labels:["坐标轴1","坐标轴2","坐标轴3","坐标轴4","坐标轴5","坐标轴6"],
  value:"70,100,90,70,100,20",
  style:{
    gridStyle: {
        color: 0xb46e42,
        width: 1,
    },
    shapeStyle: {
        color: 0x95d176,
        alpha: 0.8,
    },
    labelStyle: {
        color: "#7c3c23",
        size: 24,
    },
  }
};

