import React from 'react';
import {PolygonAxiosSystem} from "../../sourceCode/canvas/polygonAxiosSystem";
import {createStage,isExistStage} from "../../common/createStage";
import { useEffect } from 'react';
interface TestProps {
    /**坐标系统中心点x坐标 */
    centerX: number;
    /**坐标系统中心点y坐标 */
    centerY: number;
    /**坐标轴个数 */
    axiosNum:number;
    /**坐标节点个数 */
    axiosNodeNum: number;
    /**坐标系统的单位长度,一个刻度多长 */
    unitLength:number;
    /**坐标系统顺时针旋转多少度，原坐标系统基准轴水平向右，也是drawShape传的第一个数值所在的坐标轴*/
    rotateDeg?:number;
    /**坐标轴名称，默认无 */
    labels?:Array<string>;
    /**坐标系统样式*/
    style?:any;
    /**坐标值:传到坐标系统中绘制出来的值，不属于构建坐标系统的参数 */
    value:string;
  }
export const PolygonSystemCom = (args:TestProps)=>{
    createStage();
    window.stage.removeAllChildren();
    isExistStage(()=>{
      const polygonAxiosSystem = new PolygonAxiosSystem(
        args.centerX, //坐标系统原点在弹窗中的x坐标
        args.centerY, //坐标系统原点在弹窗中的y坐标
        args.axiosNum, //3个坐标轴
        args.axiosNodeNum, //3个坐标节点
        args.unitLength, //坐标系统的单位长度,一个刻度多长。
        args.rotateDeg,//坐标系统顺时针旋转多少度，原坐标系统基准轴水平向右，也是drawShape传的第一个数值所在的坐标轴。
        args.labels,
        args.style
      );
      window.stage.addChild(polygonAxiosSystem);
      polygonAxiosSystem.updateData(args.value);
    })
    return (
      <div></div>
    )
}