import React from 'react';
import {GoldCoinAni} from "../../sourceCode/canvas/goldCoinAni";
import {createStage,isExistStage} from "../../common/createStage"
import { useEffect } from 'react';
interface TestProps {
    /**动效起点,[120,30] */
    start: Array<number>;
    /**设置标题 */
    end: Array<number>;
    /**动效图片 */
    imgUrl:string;
    /**每一个金币动效结束时的回调 */
    callBack: any;
    /**true为向上凸，false为向下凹。 */
    isMinus:boolean;
    /** 0-1之间，0代表直线，1代表最弯*/
    curvature:number;
    /**动效上面金币个数 */
    goldNum:number;
    /**每一次金币移动的时间,ms*/
    time:number;
    /**路线上的坐标串个数 */
    coordNum?:number
  }
export const GoldCoinCom = (pros:TestProps)=>{
    createStage()
    isExistStage(()=>{
      window.stage.removeAllChildren();
      const goldCoinAni = new GoldCoinAni(pros.start, pros.end, pros.imgUrl, pros.callBack, pros.isMinus, pros.curvature, pros.goldNum,pros.time,pros.coordNum);
      window.stage.addChild(goldCoinAni);
      goldCoinAni.triggerAni();
    })
    return (
      <div></div>
    )
}