import React from 'react';
import { GoldCoinCom } from './GoldCoinCom';
import { CodeCom } from './codeCom';
import {
  Title,
  Subtitle,
  Description,
  ArgsTable,
  PRIMARY_STORY,
} from '@storybook/addon-docs';
import { clearStage } from '../../common/createStage';


export default {
  component: GoldCoinCom,
  title: 'Canvas组件/金币动效',
  //👇 Creates specific argTypes
  parameters: { 
    layout: 'centered',
    docs: { 
      page: () => {
        clearStage();
        return( <>
          <Title />
          <Subtitle />
          <Description />
          <ArgsTable story={PRIMARY_STORY} />
          <CodeCom></CodeCom>
        </>)
      },
    } 
  },
  
};
const goldCoinReceiveAniCallback =(goldCode)=>{

}
//👇 We create a “template” of how args map to rendering
const Template = (args) => <GoldCoinCom {...args} />;

//👇 Each story then reuses that template
export const Primary = Template.bind({});
Primary.args = {
  primary: true,
  label: '金币动效',
  start:[100, 200], 
  end:[600, 900], 
  imgUrl:"resource/homeGoldIconImg.png",
  callBack: goldCoinReceiveAniCallback.bind(this), 
  isMinus:true, 
  curvature:0.2, 
  goldNum:10, 
  time:20
};

