import React from 'react';
import { Dazhuanpan } from "../../sourceCode/canvas/dazhuanpan";
import {createStage,isExistStage} from "../../common/createStage"
import { useEffect } from 'react';
interface propsType {
    /**大转盘背景 */
    bgImg:string,
    /**大转盘转动区域 */
    innerImg:string,
    /**启动转盘按钮*/
    beginBtnImg:string;
    /**大转盘指针 */
    pointImg:string,
    /**奖品位置 */
    prizePosition:Array<number>
    /**大转盘奖品列表 */
    prizeList:Array<object>,
    /**大转盘抽奖后的回调 */
    callback:any,
    /**中奖ID */
    prizeId:any,
  }
export const DazhuanpanCom = (pros:propsType)=>{
    createStage()
    isExistStage(()=>{
      window.stage.removeAllChildren();
      const dazhuanpan = new Dazhuanpan(pros.bgImg, pros.innerImg, pros.beginBtnImg,pros.pointImg,pros.prizePosition,pros.prizeList,()=>{
        console.log("大转盘转动结束后的回调")
      });
      //@ts-ignore
      dazhuanpan.position.set(300,100)
      //设置旋转部分的位置
      dazhuanpan.setRotatePartPosition(70,70)
      //设置指针的位置
      dazhuanpan.setPointerPosition(250,0);
      //设置开始抽奖按钮的位置
      dazhuanpan.setBeginBtnPosition(220,220);

      //设置抽中的奖品；
      dazhuanpan.setHitPrize(pros.prizeId);

      window.stage.addChild(dazhuanpan);
    })
    return (
      <div></div>
    )
}