import React from 'react';
import { DazhuanpanCom } from './dazhuanpanCom';
import { CodeCom } from './codeCom';
import {
  Title,
  Subtitle,
  Description,
  ArgsTable,
  PRIMARY_STORY,
} from '@storybook/addon-docs';
import { clearStage } from '../../common/createStage';


export default {
  component: DazhuanpanCom,
  title: 'Canvas组件/大转盘',
  //👇 Creates specific argTypes
  parameters: { 
    layout: 'centered',
    docs: { 
      page: () => {
        clearStage();
        return( <>
          <Title />
          <Subtitle />
          <Description />
          <ArgsTable story={PRIMARY_STORY} />
          <CodeCom></CodeCom>
        </>)
      },
    } 
  },
  
};
const goldCoinReceiveAniCallback =(goldCode)=>{

}
//👇 We create a “template” of how args map to rendering
const Template = (args) => <DazhuanpanCom {...args} />;

//👇 Each story then reuses that template
export const Primary = Template.bind({});
Primary.args = {
  primary: true,
  label: '大转盘',
  bgImg:"resource/dazhuanpan/dazhuanpanBg.png",
  innerImg:"resource/dazhuanpan/innerPart.png",
  beginBtnImg:"resource/dazhuanpan/beginBtn.png",
  pointImg:"resource/dazhuanpan/dazhuanpanPointer.png",
  prizeId:"sss_13",
  prizePosition:[185,80],
  prizeList:[{
    icon: "//yun.dui88.com/projectxh5/coupon-250-250.png",
    id: "oe8dff3af",
    index: 1,
    name: "f优惠券",
    prizeId: "sss_11",
    prizeType: 2,
    refId: "88661",
    refType: "coupon",
  },{
    icon: "//yun.dui88.com/projectxh5/coupon-250-250.png",
    id: "o184c36c3",
    index: 2,
    name: "e优惠券",
    prizeId: "sss_12",
    prizeType: 2,
    refId: "88661",
    refType: "coupon",
    sendCount: 1,
  },{
    degree: "10",
    icon: "//yun.dui88.com/projectxh5/alipay-250-250.png",
    id: "ofd8cb484",
    index: 3,
    name: "d支付宝10",
    prizeId: "sss_13",
    prizeType: 2,
    refId: "53",
    refType: "alipay",
    sendCount: 1,
  },{
    degree: "10",
    icon: "//yun.dui88.com/projectxh5/alipay-250-250.png",
    id: "of98c438d",
    index: 4,
    name: "c支付宝10",
    prizeId: "sss_14",
    prizeType: 2,
    refId: "53",
    refType: "alipay",
    sendCount: 1,
  },{
    degree: "10",
    icon: "//yun.dui88.com/projectxh5/phonebill-250-250.png",
    id: "o527ff73c",
    index: 5,
    name: "b话费",
    prizeId: "sss_15",
    prizeType: 2,
    refId: "1",
    refType: "phonebill",
    sendCount: 1,
  },{
    degree: "10",
    icon: "//yun.dui88.com/projectxh5/phonebill-250-250.png",
    id: "of623b9e0",
    index: 6,
    name: "a话费",
    prizeId: "sss_16",
    prizeType: 2,
    refId: "1",
    refType: "phonebill",
    sendCount: 1,
  }
]
};

