import React from 'react';
import {Danmu} from "../../sourceCode/canvas/DanmuCtrl";
import {createStage,isExistStage} from "../../common/createStage";
interface propsType{
    danmuwidth:number,
    danmuheight:number,
    lines:number,
    speed:Array<number>,
    needAvatar: boolean,
}

export const DanmuCtrl = (props:propsType)=>{
    createStage();
    window.stage.removeAllChildren();
    isExistStage(()=>{
        var list =[];
        for(let i= 0;i<20;i++){
            list.push({
                avatar: "//yun.duiba.com.cn/polaris/1022.5d0247352e3f1a068cd812df9051079b111ef0a5.jpg",
                nickName: "温**暖",
                text: "免费权益融e购卡券"
            })
        }
        var danmuara = new Danmu({ datalist: list, danmuwidth: props.danmuwidth, danmuheight: props.danmuheight, lines: props.lines, speed: props.speed, needAvatar: props.needAvatar })
        //@ts-ignore
        danmuara.x = 100;
        //@ts-ignore
        danmuara.y = 100;
        window.stage.addChild(danmuara)
        danmuara.showDame()
     
    })
    return (
      <div></div>
    )
}
