import React from 'react';
import { DanmuCtrl } from './danmuCtrlCom';
import { CodeCom } from "./codeCom"
import {
  Title,
  Subtitle,
  Description,
  ArgsTable,
  PRIMARY_STORY,
} from '@storybook/addon-docs';
import { clearStage } from '../../common/createStage';
import noteText from "./notes.md"


export default {
  component: DanmuCtrl,
  title: 'Canvas组件/弹幕',
  //👇 Creates specific argTypes
  parameters: { 
    layout: 'centered',
    docs: { 
      page: () => {
        clearStage();
        return( <>
          <Title />
          <Subtitle />
          <Description />
          <ArgsTable story={PRIMARY_STORY} />
          <CodeCom></CodeCom>
        </>)
        },
    },
    notes: {noteText} 
  },
};

//👇 We create a “template” of how args map to rendering
const Template = (args) => <DanmuCtrl {...args}/>;

//👇 Each story then reuses that template
export const Primary = Template.bind({});
Primary.args = {
  primary: true,
  label: '弹幕',
  danmuwidth:750, 
  danmuheight:300, 
  lines:3,
  speed:[1, 2, 1.5], 
  needAvatar:true, 
};


