import React from 'react';
import { CarouselComponent } from "../../sourceCode/canvas/carouseComponent";
import { useEffect } from 'react';
import {createStage,isExistStage} from "../../common/createStage"
interface TestProps {
    /**item组件*/
    carouselItem: any
    /**每一个item的宽度*/
    itemWidth: number;
    /**每一个item的高度*/
    itemHeight: number;
    /**是否是垂直的 */
    vertical: boolean;
    /**要显示的个数*/
    num:number;
    /** 缓动系数，系数越大移动越快。在0-1之间*/
    k:number;
    /**轮播组件的x坐标 */
    x:number;
    /**轮播组件的y坐标 */
    y:number;
    /**轮播的数据 */
    data:any;

}

export const CarouselCom = (pros:TestProps)=>{
        createStage()
        isExistStage(()=>{
      window.stage.removeAllChildren();
      const {carouselItem,itemWidth,itemHeight,vertical,num,k} = pros
      const carouseCom = new CarouselComponent(carouselItem, itemWidth, itemHeight,vertical, num, k);
      //@ts-ignore
      carouseCom.position.set(pros.x,pros.y)
      window.stage.addChild(carouseCom);
      carouseCom.updateData(pros.data);
    })
    return (
      <div></div>
    )
}
