import React from "react";
import { CarouselCom } from "./carouselCom";
import { CodeCom } from "./codeCom";
import {
    Title,
    Subtitle,
    Description,
    ArgsTable,
    PRIMARY_STORY,
} from "@storybook/addon-docs";
import { clearStage } from "../../common/createStage";

import { Story, Meta } from "@storybook/react/types-6-0";
class carouselItem extends FYGE.Container {
    constructor(data) {
        super();
        let itemBg = FYGE.Sprite.fromUrl("resource/prizeItemBg.png");
        this.addChild(itemBg);
        let itemName = new FYGE.TextField();
        itemName.text = data.name;
        itemName.size = 24;
        itemName.fillColor = "#000000";
        itemName.textAlign = FYGE.TEXT_ALIGN.CENTER;
        itemName.textWidth = 194;
        this.addChild(itemName);
        itemName.position.set(0, 200);
        let itemImg = FYGE.Sprite.fromUrl(data.icon);
        itemBg.addChild(itemImg);
        itemImg.width = 183;
        itemImg.height = 183;
        itemImg.position.set(5, 5);
    }
}
export default {
    component: CarouselCom,
    title: "Canvas组件/横竖轮播组件",
    //👇 Creates specific argTypes
    parameters: {
        layout: "centered",
        docs: {
            page: () => {
                clearStage();
                return (
                    <>
                        <Title />
                        <Subtitle />
                        <Description />
                        <ArgsTable story={PRIMARY_STORY} />
                        <CodeCom />
                    </>
                );
            },
        },
    },
} as Meta;
//👇 We create a “template” of how args map to rendering
const Template = (args) => <CarouselCom {...args} />;

//👇 Each story then reuses that template
export const Primary = Template.bind({});
Primary.args = {
    primary: true,
    label: "金币动效",
    carouselItem: carouselItem,
    itemWidth: 204,
    itemHeight: 242,
    vertical: false,
    num: 3,
    k: 0.3,
    x: 100,
    y: 100,
    data: [
        {
            rule: "ru_1",
            name: "飞科剃须刀1",
            icon: "resource/prize.jpg",
            coins: 10000,
            stock: 111111111111,
            channel: 0,
        },
        {
            rule: "ru_1",
            name: "飞科剃须刀2",
            icon: "resource/prize.jpg",
            coins: 100,
            stock: 0,
            channel: 0,
        },
        {
            rule: "ru_1",
            name: "飞科剃须刀3",
            icon: "resource/prize.jpg",
            coins: 100,
            stock: 0,
            channel: 0,
        },
        {
            rule: "ru_1",
            name: "飞科剃须刀4",
            icon: "resource/prize.jpg",
            coins: 100,
            stock: 0,
            channel: 2,
        },
        {
            rule: "ru_1",
            name: "飞科剃须刀5",
            icon: "resource/prize.jpg",
            coins: 100,
            stock: 0,
            channel: 2,
        },
        {
            rule: "ru_1",
            name: "飞科剃须刀6",
            icon: "resource/prize.jpg",
            coins: 100,
            stock: 0,
            channel: 1,
        },
        {
            rule: "ru_1",
            name: "飞科剃须刀7",
            icon: "resource/prize.jpg",
            coins: 100,
            stock: 1,
            channel: 0,
        },
        {
            rule: "ru_1",
            name: "飞科剃须刀8",
            icon: "resource/prize.jpg",
            coins: 100,
            stock: 1,
            channel: 2,
        },
        {
            rule: "ru_1",
            name: "飞科剃须刀0",
            icon: "resource/prize.jpg",
            coins: 100,
            stock: 1,
            channel: 2,
        },
    ],
};
