import { themes } from '@storybook/theming';
import "codemirror/lib/codemirror.css";
import "codemirror/lib/codemirror.js";

import 'codemirror/mode/javascript/javascript';
import 'codemirror/mode/css/css';
import 'codemirror/theme/dracula.css';

import "codemirror/addon/fold/foldcode.js";
import "codemirror/addon/fold/foldgutter.js";
import "codemirror/addon/fold/brace-fold.js";
import "codemirror/addon/fold/comment-fold.js";
import { addParameters ,configure} from '@storybook/react';
import "./global.less";

addParameters({
  options: {
    theme:{
      brandTitle:'DUI',
      brandUrl: null,
    },
  }
});

const customViewports = {
    kindleFire2: {
      name: 'Kindle Fire 2',
      styles: {
        width: '600px',
        height: '963px',
      },
    },
    kindleFireHD: {
      name: 'Kindle Fire HD',
      styles: {
        width: '750px',
        height: '1624px',
      },
    },
  };
export const parameters = {
    layout: 'centered',
    controls: {
      matchers: {
        color: /(background|color)$/i,
        date: /Date$/,
      },
    },
    docs: {
        theme: themes.dark,
    },
    viewport: { viewports: customViewports },
    options: {
      storySort: {
        order: ["Introduction","组件概览","React组件概览","Canvas组件","React组件"], 
      },
    },
  };
  