import React from 'react';

import common from 'src/lib/common';
import PermissionTool from 'src/lib/permissionTools';

import {
  Layout
} from 'antd';

import Header from 'src/components/header';
import Menu from 'src/components/menu';
import Footer from 'src/components/footer';

import 'src/styles/antd.less';
import styles from 'src/styles/index.less';

const { Content } = Layout;

export default class App extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      dataIsReady: false, // 用于判断数据是否获取完成标识
      currentAccount: {
        name: '',
        email: ''
      } // 当前用户信息
    };
  }
  componentDidMount() {
    this.fetcUserInfo();
  }
  // 获取用户信息数据
  fetcUserInfo = () => {
    const actions = ['/auth/getAuthList', '/sso/admin/adminInfo'];
    Promise.all(actions.map(action => {
      return common.fetch(action, {}, 'get');
    }))
      .then(datas => {
        const [authInfoData = {}, userInfoData = {}] = datas;
        const { success: getAuthSuccess, authList } = authInfoData;
        const { success: getUserInfoSuccess, adminName: name } = userInfoData;
        // 权限数据获取
        if (getAuthSuccess) {
          PermissionTool.setPermissions(authList);
          this.setState({
            dataIsReady: true
          });
        } else {
          // 已经统一处理
          //  const { success: getAuthSuccess, authList, desc } = authInfoData;
          // common.handleError(desc);
        }
        // 用户信息获取
        if (getUserInfoSuccess) {
          this.setState({
            currentAccount: {
              name
            }
          });
        }
      });
  }
  render() {
    const { currentAccount, dataIsReady } = this.state;
    const { router, children } = this.props;
    const { getCurrentLocation } = router;
    return dataIsReady ? (
      <Layout className={styles.app_container}>
        <Header accountInfo={currentAccount}/>
        <Layout>
          <Menu currentLocation={getCurrentLocation()}/>
          <Layout className={styles.content_wrap}>
            <Content className={styles.content_container}>
              {children}
            </Content>
            <Footer />
          </Layout>
        </Layout>
      </Layout>
    ) : null;
  }
}
