import { observable, action } from 'mobx';
import common from 'src/lib/common';
import { Modal, message } from 'antd';

const confirm = Modal.confirm;

class State {
  @observable
  dataIsLoading = false;
  // 请求参数
  @observable
  params = {
    pageSize: 10,
    sceneId: '',
    currentPage: 1
  };
  // 更新params
  @action
  updateParams = (params) => {
    this.params = Object.assign({}, this.params, params);
  }
  // table数据
  @observable
  dataList = {
    list: []
  };
  // 获取table数据
  @action
  getDataList = () => {
    this.dataIsLoading = true;
    let params = Object.assign({}, this.params);
    common.fetch('/strategy/list', params, 'get', {content: {deleteNullAndUndefinedParams: true}})
      .then(res => {
        this.dataIsLoading = false;
        this.dataList = res.data || ({
          list: []
        });
      });
  }
  // 获取所有场景
  @observable
  sceneIdsArr = [];
  // 获取table数据
  @action
  getAllScence = () => {
    common.fetch('/engineScene/queryAllScene', {}, 'get')
      .then(res => {
        this.sceneIdsArr = res.data;
      });
  }
  // 编辑 策略名称重复判断
  @action
  checkStrategyName = (params, strategyName) => {
    return new Promise((resolve) => {
      common.fetch('/strategy/exists', {strategyName: strategyName}, 'get')
        .then(res => {
          if (res.data === 'Not exists') {
            resolve(res);
            this.saveStrategyList(params);
          } else {
            message.warning(res.data);
          }
        });
    });
  }
  // 新增 策略名称,策略标识重复判断
  @action
  checkStrategyKeyOrName = (params, addParams) => {
    return new Promise((resolve) => {
      common.fetch('/strategy/exists', addParams, 'get')
        .then(res => {
          if (res.data === 'Not exists') {
            resolve(res);
            this.saveStrategyList(params);
          } else {
            message.warning(res.data);
          }
        });
    });
  }
  // 添加/更新策略
  @action
  saveStrategyList = (params) => {
    return new Promise((resolve) => {
      common.fetch('/strategy/save', params, 'post', {isJson: true})
        .then(res => {
          resolve(res);
          this.getDataList();
        });
    });
  }
  // 删除策略
  @action
  deleteStrategy = (key) => {
    common.fetch('/strategy/delete', {key: key}, 'post', {isJson: true})
      .then(res => {
        common.handleSuccess('删除成功！');
        this.getDataList();
      });
  }
  // 校验该策略下有无关联规则
  @action
  checkIsRule = (key) => {
    common.fetch('/strategy/hasRule', {strategyKey: key}, 'get')
      .then(res => {
        if (res.data === false) {
          confirm({
            title: '提示',
            content: '确认删除?',
            okText: '确定',
            okType: 'danger',
            cancelText: '取消',
            onOk: () => {
              this.deleteStrategy(key);
            },
            onCancel() {
              console.log('you chose close!');
            }
          });
        } else {
          message.warning('策略下已关联规则，无法删除!');
        }
      });
  }
}

const store = new State();
export default store;
