import React from 'react';
import { observer } from 'mobx-react';
import store from '../store';
import {
  Form,
  Input,
  Modal,
  Select,
  Slider
} from 'antd';
import styles from './editModal.less';

const FormItem = Form.Item;
const Option = Select.Option;
let TextArea = Input.TextArea;

@observer
class Edit extends React.Component {
  handleOk = () => {
    this.props.form.validateFields((err, values) => {
      if (!err) {
        const { checkStrategyKeyOrName, checkStrategyName, saveStrategyList } = store;
        const { getFieldValue } = this.props.form;
        let params = {
          strategyName: getFieldValue('strategyName'),
          strategyKey: getFieldValue('strategyKey'),
          strategyType: 0,
          sceneId: getFieldValue('sceneId'),
          score1: parseInt(getFieldValue('score1')),
          score2: parseInt(getFieldValue('score2')),
          score3: parseInt(getFieldValue('score3')),
          score4: parseInt(getFieldValue('score4')),
          status: 1,
          description: getFieldValue('description')
        };
        if ((getFieldValue('strategyName') !== this.props.editObj.strategyName) && this.props.isEdit) {
          checkStrategyName(params, values.strategyName).then(this.props.closeModal);
        } else if (this.props.isEdit) {
          saveStrategyList(params).then(this.props.closeModal);
        }
        if (!this.props.isEdit) {
          let addParams = {
            strategyName: params.strategyName,
            strategyKey: params.strategyKey
          };
          checkStrategyKeyOrName(params, addParams).then(this.props.closeModal);
        }
      }
    });
  };
  handleCancel = () => {
    this.props.closeModal();
  };
  // 自定义校验
  checkConfirm = (rule, value, callback, i) => {
    const { getFieldValue } = this.props.form;
    if (getFieldValue(`score${i}`) > getFieldValue(`score${i + 1}`)) {
      callback('输入了不合法的数值！');// eslint-disable-line
    }
    if (getFieldValue(`score${i}`) < getFieldValue(`score${i - 1}`)) {
      callback('输入了不合法的数值！');// eslint-disable-line
    }
    callback();
  }
  render() {
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 6 }
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 16 }
      }
    };
    const { getFieldDecorator } = this.props.form;
    const { sceneIdsArr } = store;
    // 策略名称
    let strategyNameProps = getFieldDecorator('strategyName', {
      initialValue: this.props.editObj.strategyName || '',
      rules: [{
        required: true, message: '请输入！'
      }, {
        max: 30, message: '最多输入30个字符！'
      }]
    });
    // 策略标识
    let strategyKeyProps = getFieldDecorator('strategyKey', {
      initialValue: this.props.editObj.strategyKey || '',
      rules: [{
        required: true, message: '请输入！'
      }]
    });
    // 关联场景
    let sceneTypeProps = getFieldDecorator('sceneId', {
      initialValue: this.props.editObj.sceneId || (sceneIdsArr.length ? sceneIdsArr[0].id : ''),
      rules: [{
        required: true, message: '请输入！'
      }]
    });
    // 阈值
    let score1Props = getFieldDecorator('score1', {
      initialValue: this.props.editObj.score1,
      rules: [{
        required: true, pattern: /^[0-9]+$/, message: '请输入数字！'
      }, { validator: (rule, value, callback) => { return this.checkConfirm(rule, value, callback, 1); } }]
    });
    let score2Props = getFieldDecorator('score2', {
      initialValue: this.props.editObj.score2,
      rules: [{
        required: true, pattern: /^[0-9]+$/, message: '请输入数字！'
      }, { validator: (rule, value, callback) => { return this.checkConfirm(rule, value, callback, 2); } }]
    });
    let score3Props = getFieldDecorator('score3', {
      initialValue: this.props.editObj.score3,
      rules: [{
        required: true, pattern: /^[0-9]+$/, message: '请输入数字！'
      }, { validator: (rule, value, callback) => { return this.checkConfirm(rule, value, callback, 3); } }]
    });
    let score4Props = getFieldDecorator('score4', {
      initialValue: this.props.editObj.score4,
      rules: [{
        required: true, pattern: /^[0-9]+$/, message: '请输入数字！'
      }, { validator: (rule, value, callback) => { return this.checkConfirm(rule, value, callback, 4); } }]
    });
    // 描述
    let descriptionProps = getFieldDecorator('description', {
      initialValue: this.props.editObj.description || '',
      rules: [{
        max: 64, message: '最多输入64个字符！'
      }]
    });
    return (
      <div>
        <Modal
          title={ this.props.isEdit ? '编辑策略' : '新建策略'}
          width={450}
          visible={true}
          maskClosable={false}
          onOk={this.handleOk}
          onCancel={this.handleCancel}
          okText="保存"
          cancelText="取消"
        >
          <Form>
            <FormItem
              {...formItemLayout}
              label="策略名称"
            >
              {strategyNameProps(
                <Input type="text" />
              )}
            </FormItem>
            <FormItem
              {...formItemLayout}
              label="策略标识"
            >
              {strategyKeyProps(
                <Input disabled={this.props.isEdit} type="text" />
              )}
            </FormItem>
            <FormItem
              {...formItemLayout}
              label="关联场景"
            >
              {
                sceneTypeProps(
                  <Select
                    style={{ width: '100%' }}
                    placeholder="请选择"
                  >
                    {sceneIdsArr && sceneIdsArr.map((d, index) => <Option key={index} value={d.id}>{d.sceneName}</Option>)}
                  </Select>
                )
              }
            </FormItem>
            <div className={styles.steps}>
              <div className={styles.tips}><span>通过</span><span>人审</span><span>拒绝</span></div>
              <Slider className={styles.step} step={5} range min={0} disabled={true} max={5} tipFormatter={null} defaultValue={[0, 5]} />
              <Slider className={styles.step} step={5} min={0} disabled={true} max={5} tipFormatter={null} defaultValue={5} />
              <Slider className={styles.step} step={5} min={0} disabled={true} max={5} tipFormatter={null} defaultValue={5} />
            </div>
            <FormItem className={`${styles.score_block} ${styles.fir_score_block}`}>
              {score1Props(
                <Input type="text" />
              )}
            </FormItem>
            <FormItem className={styles.score_block}>
              {score2Props(
                <Input type="text" />
              )}
            </FormItem>
            <FormItem className={styles.score_block}>
              {score3Props(
                <Input type="text" />
              )}
            </FormItem>
            <FormItem className={styles.score_block}>
              {score4Props(
                <Input type="text" />
              )}
            </FormItem>
            <FormItem
              {...formItemLayout}
              label="描述："
            >
              {descriptionProps(
                <TextArea rows={3} />
              )}
            </FormItem>
          </Form>
        </Modal>
      </div>
    );
  }
}

const EditModal = Form.create({})(Edit);
export default EditModal;
