import React from 'react';
import { observer } from 'mobx-react';
import store from '../store';
import {
  Form,
  Input,
  Modal,
  Select
} from 'antd';
const FormItem = Form.Item;
const Option = Select.Option;
let TextArea = Input.TextArea;
const sceneTypeArr = [
  { value: 0, text: '实时场景' },
  { value: 1, text: '准实时场景' }
];
@observer
class Edit extends React.Component {
  handleOk = () => {
    this.props.form.validateFields((err, values) => {
      if (!err) {
        const { checkSceneName } = store;
        const { getFieldValue } = this.props.form;
        let params = {
          sceneName: getFieldValue('sceneName'),
          sceneKey: getFieldValue('sceneKey'),
          sceneType: parseInt(getFieldValue('sceneType')),
          description: getFieldValue('description'),
          gmtCreate: this.props.editObj.gmtCreate || '',
          creator: this.props.editObj.creator || '',
          id: this.props.editObj.id
        };
        let isEdit = this.props.isEdit;
        checkSceneName(params, isEdit).then(this.props.closeModal);
      }
    });
  };
  handleCancel = () => {
    this.props.closeModal();
  };
  render() {
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 8 }
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 16 }
      }
    };
    const { getFieldDecorator } = this.props.form;
    // 场景名称
    let sceneNameProps = getFieldDecorator('sceneName', {
      initialValue: this.props.editObj.sceneName || '',
      rules: [{
        required: true, message: '请输入！'
      }, {
        max: 30, message: '最多输入30个字符！'
      }]
    });
    // 场景标识
    let sceneKeyProps = getFieldDecorator('sceneKey', {
      initialValue: this.props.editObj.sceneKey || '',
      rules: [{
        required: true, message: '请输入！'
      }]
    });
    // 场景类型
    let sceneTypeProps = getFieldDecorator('sceneType', {
      initialValue: typeof this.props.editObj.sceneType === 'undefined' ? 0 : this.props.editObj.sceneType,
      rules: [{
        required: true, message: '请输入！'
      }]
    });
    // 描述
    let descriptionProps = getFieldDecorator('description', {
      initialValue: this.props.editObj.description || '',
      rules: [{
        max: 64, message: '最多输入64个字符！'
      }]
    });
    return (
      <div>
        <Modal
          title={ this.props.isEdit ? '编辑场景' : '新建场景'}
          width={400}
          visible={true}
          maskClosable={false}
          onOk={this.handleOk}
          onCancel={this.handleCancel}
          okText="保存"
          cancelText="取消"
        >
          <Form>
            <FormItem
              {...formItemLayout}
              label="场景名称"
            >
              {sceneNameProps(
                <Input type="text" />
              )}
            </FormItem>
            <FormItem
              {...formItemLayout}
              label="场景标识"
            >
              {sceneKeyProps(
                <Input disabled={this.props.isEdit} type="text" />
              )}
            </FormItem>
            <FormItem
              {...formItemLayout}
              label="场景类型"
            >
              {
                sceneTypeProps(
                  <Select
                    style={{ width: '100%' }}
                    placeholder="Tags Mode"
                  >
                    {sceneTypeArr && sceneTypeArr.map((d, index) => <Option key={index} value={d.value}>{d.text}</Option>)}
                  </Select>
                )
              }
            </FormItem>
            <FormItem
              {...formItemLayout}
              label="描述："
            >
              {descriptionProps(
                <TextArea rows={3} />
              )}
            </FormItem>
          </Form>
        </Modal>
      </div>
    );
  }
}

const EditModal = Form.create({})(Edit);
export default EditModal;
