import React from 'react';
import { observer } from 'mobx-react';
import common from 'src/lib/common';

import { Form, Input, Icon, Button, Select, Radio, Modal } from 'antd';

import store from '../store';

import styles from './flowAndScore.less';

const confirm = Modal.confirm;
const FormItem = Form.Item;
const RadioGroup = Radio.Group;
const Option = Select.Option;
const operationArr = [
  { value: 0, text: '>' },
  { value: 1, text: '<' },
  { value: 2, text: '=' },
  { value: 3, text: '>=' },
  { value: 4, text: '<=' },
  { value: 5, text: '≠' },
  { value: 6, text: '>and<=' },
  { value: 7, text: '>and<' },
  { value: 8, text: '>=and<' },
  { value: 9, text: '>=and<=' },
  { value: 10, text: '包含' },
  { value: 11, text: '不包含' }
];
let uuid = 1;
@observer
class FlowScoreForm extends React.Component {
  remove = (k) => {
    const { form } = this.props;
    const conditions = form.getFieldValue('conditions');
    if (conditions.length === 1) {
      return;
    }
    if (k.threshold) {
      confirm({
        title: '提示',
        content: '确认修改?',
        okText: '确定',
        okType: 'danger',
        cancelText: '取消',
        onOk: () => {
          form.setFieldsValue({
            conditions: conditions.filter(key => key !== k)
          });
        },
        onCancel() {
          console.log('you chose close!');
        }
      });
    } else {
      form.setFieldsValue({
        conditions: conditions.filter(key => key !== k)
      });
    }
  }

  add = () => {
    const { form } = this.props;
    const conditions = form.getFieldValue('conditions');
    const nextConditions = conditions.concat(uuid);
    ++uuid;
    form.setFieldsValue({
      conditions: nextConditions
    });
  }

  componentDidMount = () => {
    if (this.props.editObj.id) {
      let conditionsArr = [];
      common.fetch(`/rules/${this.props.editObj.id}/conditions`, {}, 'get')
        .then(res => {
          conditionsArr = res.data;
          this.props.form.setFieldsValue({
            conditions: conditionsArr
          });
        });
    }
  }

  render() {
    const { fieldArr } = store;
    const { getFieldDecorator, getFieldValue } = this.props.form;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 4 }
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 20 }
      }
    };
    const formItemLayoutWithOutLabel = {
      wrapperCol: {
        xs: { span: 24, offset: 0 },
        sm: { span: 20, offset: 4 }
      }
    };
    const formExpressionLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 8 }
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 16 }
      }
    };
    const formThresholdLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 6 }
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 }
      }
    };
    getFieldDecorator('conditions', { initialValue: getFieldValue('conditions') && getFieldValue('conditions').length > 0 ? getFieldValue('conditions') : [0] });
    const conditions = getFieldValue('conditions');
    const formItems = conditions.map((k, index) => {
      if (typeof k === 'object') {
        return (
          <div key={k.id ? k.id : 'new' + k} className={styles.conditions}>
            <FormItem className={styles.condition} style={{ width: '25%' }}>
              {getFieldDecorator(`fieldId[${index}]`, {
                initialValue: k.fieldId || fieldArr ? fieldArr[0].id : '',
                rules: [{
                  required: true,
                  message: '请选择'
                }]
              })(
                <Select
                  placeholder="请选择"
                >
                  {fieldArr && fieldArr.map((d, index) => <Option key={index} value={d.id}>{d.name}</Option>)}
                </Select>
              )}
            </FormItem>
            <FormItem className={styles.condition}
              style={{ width: '35%' }}
              {...formExpressionLayout}
              label="表达式:">
              {getFieldDecorator(`operation[${index}]`, {
                initialValue: k.operation || 0
              })(
                <Select
                  placeholder="请选择"
                >
                  {operationArr && operationArr.map((d, index) => <Option key={index} value={d.value}>{d.text}</Option>)}
                </Select>
              )}
            </FormItem>
            <FormItem className={styles.condition}
              style={{ width: '30%' }}
              {...formThresholdLayout}
              label="值:">
              {getFieldDecorator(`threshold[${index}]`, {
                initialValue: k.threshold || '',
                rules: [{
                  required: true,
                  message: '请选择'
                }]
              })(
                <Input
                  className={styles.add_condition}
                  placeholder="请输入" />
              )}
            </FormItem>
            <Icon
              className={styles.dynamic_delete_button}
              type="minus-circle-o"
              disabled={conditions.length === 1}
              onClick={() => this.remove(k)}
            />
          </div>
        );
      }
      return (
        <div key={k.id ? k.id : 'new' + (k)} className={styles.conditions}>
          <FormItem className={styles.condition} style={{ width: '25%' }}>
            {getFieldDecorator(`new_fieldId[${k}]`, {
              initialValue: k.fieldId || fieldArr ? fieldArr[0].id : '',
              rules: [{
                required: true,
                message: '请选择'
              }]
            })(
              <Select
                placeholder="请选择"
              >
                {fieldArr && fieldArr.map((d, index) => <Option key={index} value={d.id}>{d.name}</Option>)}
              </Select>
            )}
          </FormItem>
          <FormItem className={styles.condition}
            style={{ width: '35%' }}
            {...formExpressionLayout}
            label="表达式:">
            {getFieldDecorator(`new_operation[${k}]`, {
              initialValue: k.operation || 0
            })(
              <Select
                placeholder="请选择"
              >
                {operationArr && operationArr.map((d, index) => <Option key={index} value={d.value}>{d.text}</Option>)}
              </Select>
            )}
          </FormItem>
          <FormItem className={styles.condition}
            style={{ width: '30%' }}
            {...formThresholdLayout}
            label="值:">
            {getFieldDecorator(`new_threshold[${k}]`, {
              initialValue: k.new_threshold || '',
              rules: [{
                required: true,
                message: '请选择'
              }]
            })(
              <Input
                className={styles.add_condition}
                placeholder="请输入" />
            )}
          </FormItem>
          <Icon
            className={styles.dynamic_delete_button}
            type="minus-circle-o"
            disabled={conditions.length === 1}
            onClick={() => this.remove(k)}
          />
        </div>
      );
    });
    let nameProps = getFieldDecorator('name', {
      initialValue: this.props.editObj.name || '',
      rules: [{
        required: true, message: '请输入！'
      }, {
        max: 30, message: '最多输入30个字符！'
      }]
    });
    let decisionProps = this.props.type === '1' ? getFieldDecorator('decision', {
      initialValue: this.props.editObj.decision || '',
      rules: [{
        required: true, pattern: /^[0-9]+$/, message: '请输入数字！'
      }]
    }) : null;
    let modeProps = getFieldDecorator('mode', {
      initialValue: this.props.editObj.mode || 0
    });
    return (
      <Form>
        <p className={styles.modalTitle}>基础属性</p>
        <FormItem
          {...formItemLayout}
          label="规则名称"
        >
          {nameProps(
            <Input type="text" style={{ width: '60%' }}/>
          )}
        </FormItem>
        {this.props.type === '1' ? <FormItem
          {...formItemLayout}
          label="风险决策"
        >
          <div>{decisionProps(
            <Input type="text" style={{ width: '40%', marginRight: 8 }}/>
          )}分</div>
        </FormItem> : null}
        <p className={styles.modalTitle}>条件配置</p>
        <FormItem
          {...formItemLayout}
          label="命中模式"
        >
          {modeProps(
            <RadioGroup>
              <Radio value={0}>全部满足</Radio>
              <Radio value={1}>满足任一</Radio>
            </RadioGroup>
          )}
        </FormItem>
        {formItems}
        <FormItem {...formItemLayoutWithOutLabel}>
          <Button
            className={styles.addbutton}
            onClick={this.add}
            style={{ marginRight: 8 }}
            type="dashed"
          >新增</Button>
        </FormItem>
      </Form>
    );
  }
}
export default Form.create({})(FlowScoreForm);
