import React from 'react';
// import { observer } from 'mobx-react';
import styles from './index.less';

import {
  DatePicker,
  Form,
  Input,
  Select,
  Button
} from 'antd';
import moment from 'moment';
const FormItem = Form.Item;
const Option = Select.Option;
const { RangePicker } = DatePicker;
const dateFormat = 'YYYY-MM-DD';
// 风险等级枚举
const cheatGradeArr = [];
const riskReviewerArr = [];

// @observer
class SearchFilter extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      loading: false,
      time: [moment().subtract(1, 'days'), moment().subtract(0, 'days')]
    };
  }
  componentDidMount() {
    this.search();
  }
  // 查询
  search = () => {}
  render() {
    const { getFieldDecorator } = this.props.form;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 8 }
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 16 }
      }
    };
    let orderProps = getFieldDecorator('slotId');
    let userIdProps = getFieldDecorator('appId');
    // 日期选择器
    let timeProps = getFieldDecorator('time', {
      initialValue: this.state.time
    });
    // 处理人
    let scnceProps = getFieldDecorator('riskReviewer', {
      initialValue: ''
    });
    // 作弊等级
    let resultProps = getFieldDecorator('cheatGrade', {
      initialValue: ''
    });
    // 初步处理结果
    let equipmentIdProps = getFieldDecorator('preResult', {
      initialValue: ''
    });
    // 媒体意见
    let ipProps = getFieldDecorator('mediaDealOpinion', {
      initialValue: ''
    });
    return (
      <div className={styles.search_warp}>
        <Form layout="inline" >
          <FormItem>
            {timeProps(
              <RangePicker
                format={dateFormat}
              />
            )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="场景"
          >
            {scnceProps(
              <Select
                style={{ width: '100px' }}
                placeholder="Tags Mode"
              >
                {riskReviewerArr && riskReviewerArr.map((d, index) => <Option key={index} value={d.value}>{d.text}</Option>)}
              </Select>
            )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="审核结果"
          >
            {resultProps(
              <Select
                style={{ width: '120px' }}
                placeholder="Tags Mode"
              >
                {cheatGradeArr && cheatGradeArr.map((d, index) => <Option key={index} value={d.value}>{d.text}</Option>)}
              </Select>
            )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="订单号"
          >
            {orderProps(
              <Input type="text" />
            )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="用户ID"
          >
            {userIdProps(
              <Input type="text" />
            )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="设备ID"
          >
            {equipmentIdProps(
              <Input type="text" />
            )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="IP地址"
          >
            {ipProps(
              <Input type="text" />
            )}
          </FormItem>
          <FormItem>
            <Button
              type="primary"
              htmlType="submit"
              onClick={this.search}
            >
              查询
            </Button>
          </FormItem>
        </Form>
      </div>
    );
  }
}

const PageSearch = Form.create({})(SearchFilter);
export default PageSearch;
