import React from 'react';
import { observer } from 'mobx-react';
import store from '../store';
import {
  Form,
  Input,
  Modal,
  Select
} from 'antd';
const FormItem = Form.Item;
const Option = Select.Option;
let TextArea = Input.TextArea;
const typeArr = [
  { value: '0', text: '数值' },
  { value: '1', text: '字符串' }];
const tableNameArr = [
  { value: '1', text: '用户' },
  { value: '2', text: '设备' },
  { value: '3', text: 'ip' },
  { value: '4', text: 'ip前三段' },
  { value: '5', text: 'UA' }];
@observer
class Edit extends React.Component {
  handleOk = () => {
    this.props.form.validateFields((err, values) => {
      if (!err) {
        const { checkFieldName, updateFieldList } = store;
        const { getFieldValue } = this.props.form;
        let params = {
          name: getFieldValue('name'),
          type: getFieldValue('type'),
          tableName: getFieldValue('tableName'),
          tableColumn: getFieldValue('tableColumn'),
          sceneIds: getFieldValue('sceneIds'),
          description: getFieldValue('description'),
          gmtCreate: this.props.editObj.gmtCreate || '',
          creator: this.props.editObj.creator || '',
          id: this.props.editObj.id
        };
        let isEdit = this.props.isEdit;
        if ((getFieldValue('name') !== this.props.editObj.name) && this.props.isEdit) {
          checkFieldName(params, isEdit, values.name).then(this.props.closeModal);
        } else if (this.props.isEdit) {
          updateFieldList(params).then(this.props.closeModal);
        }
        if (!this.props.isEdit) {
          checkFieldName(params, isEdit, values.name).then(this.props.closeModal);
        }
      }
    });
  };
  handleCancel = () => {
    this.props.closeModal();
  };
  render() {
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 6 }
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 16 }
      }
    };
    const { sceneIdsArr, isFieldArr } = store;
    const { getFieldDecorator } = this.props.form;
    let sceneArr = [];
    this.props.editObj.sceneNames && this.props.editObj.sceneNames.forEach(item => {
      sceneArr.push(item.sceneId);
    });
    // 字段名称
    let nameProps = getFieldDecorator('name', {
      initialValue: this.props.editObj.name || '',
      rules: [{
        required: true, message: '请输入！'
      }, {
        max: 30, message: '最多输入30个字符！'
      }]
    });
    // 字段类型
    let typeProps = getFieldDecorator('type', {
      initialValue: this.props.editObj.type || '0'
    });
    // 维度
    let tableNameProps = getFieldDecorator('tableName', {
      initialValue: this.props.editObj.tableName || '1'
    });
    // 表字段
    let tableColumnProps = getFieldDecorator('tableColumn', {
      initialValue: this.props.editObj.tableColumn,
      rules: [{
        required: true, message: '请输入！'
      }]
    });
    // 所属场景
    let sceneIdsProps = getFieldDecorator('sceneIds', {
      initialValue: sceneArr || '',
      rules: [{
        required: true, message: '请选择！'
      }]
    });
    // 描述
    let descriptionProps = getFieldDecorator('description', {
      initialValue: this.props.editObj.description || '',
      rules: [{
        max: 64, message: '最多输入64个字符！'
      }]
    });
    return (
      <div>
        <Modal
          title={ this.props.isEdit ? '编辑字段' : '新建字段'}
          width={400}
          visible={true}
          maskClosable={false}
          onOk={this.handleOk}
          onCancel={this.handleCancel}
          okText="保存"
          cancelText="取消"
        >
          <Form>
            <FormItem
              {...formItemLayout}
              label="字段名称"
            >
              {nameProps(
                <Input type="text" />
              )}
            </FormItem>
            <FormItem
              {...formItemLayout}
              label="字段类型"
            >
              {typeProps(
                <Select
                  style={{ width: '100%' }}
                  placeholder="请选择"
                >
                  {typeArr && typeArr.map((d, index) => <Option key={index} value={d.value}>{d.text}</Option>)}
                </Select>
              )}
            </FormItem>
            <FormItem
              {...formItemLayout}
              label="维度"
            >
              {
                tableNameProps(
                  <Select
                    style={{ width: '100%' }}
                    placeholder="请选择"
                  >
                    {tableNameArr && tableNameArr.map((d, index) => <Option key={index} value={d.value}>{d.text}</Option>)}
                  </Select>
                )
              }
            </FormItem>
            <FormItem
              {...formItemLayout}
              label="表字段"
            >
              {
                tableColumnProps(
                  <Input type="text" />
                )
              }
            </FormItem>
            <FormItem
              {...formItemLayout}
              label="所属场景"
            >
              {
                sceneIdsProps(
                  <Select
                    mode="multiple"
                    style={{ width: '100%' }}
                    placeholder="请选择"
                    // onDeselect={this.handleDel}
                  >
                    {sceneIdsArr && sceneIdsArr.map((d, index) => <Option disabled={isFieldArr.indexOf(d.id) !== -1} key={index} value={d.id}>{d.sceneName}</Option>)}
                  </Select>
                )
              }
            </FormItem>
            <FormItem
              {...formItemLayout}
              label="描述："
            >
              {descriptionProps(
                <TextArea rows={3} />
              )}
            </FormItem>
          </Form>
        </Modal>
      </div>
    );
  }
}

const EditModal = Form.create({})(Edit);
export default EditModal;
